/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.http.annotation.HasFormData;

public class HasFormDataAnnotation {
    public static final HasFormData DEFAULT = HasFormDataAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AnnotationBuilder {
        String name = "";
        String value = "";

        protected Builder() {
            super(HasFormData.class);
        }

        public HasFormData build() {
            return new Impl(this);
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }
    }

    private static class Impl
    extends AnnotationImpl
    implements HasFormData {
        private final String name;
        private final String value;

        Impl(Builder b) {
            super(b);
            this.name = b.name;
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

