/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.swap.StringSwap;

public abstract class ByteArraySwap
extends StringSwap<byte[]> {

    public static class SpacedHex
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.toSpacedHex((byte[])b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.fromSpacedHex((String)s);
        }
    }

    public static class Hex
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.toHex((byte[])b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.fromHex((String)s);
        }
    }

    public static class Base64
    extends ByteArraySwap {
        @Override
        public String swap(BeanSession session, byte[] b) throws Exception {
            return StringUtils.base64Encode((byte[])b);
        }

        @Override
        public byte[] unswap(BeanSession session, String s, ClassMeta<?> hint) throws Exception {
            return StringUtils.base64Decode((String)s);
        }
    }
}

