/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.parser.ParseException;

@Bean
public class UriContext {
    public static final UriContext DEFAULT = new UriContext();
    public final String authority;
    public final String contextRoot;
    public final String servletPath;
    public final String pathInfo;
    public final String parentPath;
    private String aContextRoot;
    private String rContextRoot;
    private String aServletPath;
    private String rResource;
    private String aPathInfo;
    private String rPath;

    public static UriContext of(String authority, String contextRoot, String servletPath, String pathInfo) {
        return new UriContext(authority, contextRoot, servletPath, pathInfo);
    }

    public static UriContext of(String s) {
        try {
            return new UriContext(s);
        }
        catch (ParseException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    @Beanc
    public UriContext(@Name(value="authority") String authority, @Name(value="contextRoot") String contextRoot, @Name(value="servletPath") String servletPath, @Name(value="pathInfo") String pathInfo) {
        this.authority = StringUtils.nullIfEmpty(StringUtils.trimSlashes(authority));
        this.contextRoot = StringUtils.nullIfEmpty(StringUtils.trimSlashes(contextRoot));
        this.servletPath = StringUtils.nullIfEmpty(StringUtils.trimSlashes(servletPath));
        this.pathInfo = StringUtils.nullIfEmpty(StringUtils.trimSlashes(pathInfo));
        this.parentPath = this.pathInfo == null || this.pathInfo.indexOf(47) == -1 ? null : this.pathInfo.substring(0, this.pathInfo.lastIndexOf(47));
    }

    public UriContext() {
        this(null, null, null, null);
    }

    public UriContext(String s) throws ParseException {
        JsonMap m = JsonMap.ofJson(s);
        this.authority = StringUtils.nullIfEmpty(StringUtils.trimSlashes(m.getString("authority")));
        this.contextRoot = StringUtils.nullIfEmpty(StringUtils.trimSlashes(m.getString("contextRoot")));
        this.servletPath = StringUtils.nullIfEmpty(StringUtils.trimSlashes(m.getString("servletPath")));
        this.pathInfo = StringUtils.nullIfEmpty(StringUtils.trimSlashes(m.getString("pathInfo")));
        this.parentPath = this.pathInfo == null || this.pathInfo.indexOf(47) == -1 ? null : this.pathInfo.substring(0, this.pathInfo.lastIndexOf(47));
    }

    public String getAbsoluteAuthority() {
        return this.authority == null ? "/" : this.authority;
    }

    public String getAbsoluteContextRoot() {
        if (this.aContextRoot == null) {
            this.aContextRoot = this.authority == null ? this.getRootRelativeContextRoot() : (this.contextRoot == null ? this.authority : this.authority + "/" + this.contextRoot);
        }
        return this.aContextRoot;
    }

    public String getRootRelativeContextRoot() {
        if (this.rContextRoot == null) {
            this.rContextRoot = this.contextRoot == null ? "/" : "/" + this.contextRoot;
        }
        return this.rContextRoot;
    }

    public String getAbsoluteServletPath() {
        if (this.aServletPath == null) {
            this.aServletPath = this.authority == null ? this.getRootRelativeServletPath() : (this.contextRoot == null ? (this.servletPath == null ? this.authority : this.authority + "/" + this.servletPath) : (this.servletPath == null ? this.authority + "/" + this.contextRoot : this.authority + "/" + this.contextRoot + "/" + this.servletPath));
        }
        return this.aServletPath;
    }

    public String getRootRelativeServletPath() {
        if (this.rResource == null) {
            this.rResource = this.contextRoot == null ? (this.servletPath == null ? "/" : "/" + this.servletPath) : (this.servletPath == null ? "/" + this.contextRoot : "/" + this.contextRoot + "/" + this.servletPath);
        }
        return this.rResource;
    }

    public String getAbsoluteServletPathParent() {
        return UriContext.getParent(this.getAbsoluteServletPath());
    }

    public String getRootRelativeServletPathParent() {
        return UriContext.getParent(this.getRootRelativeServletPath());
    }

    public String getAbsolutePathInfo() {
        if (this.aPathInfo == null) {
            this.aPathInfo = this.authority == null ? this.getRootRelativePathInfo() : (this.contextRoot == null ? (this.servletPath == null ? (this.pathInfo == null ? this.authority : this.authority + "/" + this.pathInfo) : (this.pathInfo == null ? this.authority + "/" + this.servletPath : this.authority + "/" + this.servletPath + "/" + this.pathInfo)) : (this.servletPath == null ? (this.pathInfo == null ? this.authority + "/" + this.contextRoot : this.authority + "/" + this.contextRoot + "/" + this.pathInfo) : (this.pathInfo == null ? this.authority + "/" + this.contextRoot + "/" + this.servletPath : this.authority + "/" + this.contextRoot + "/" + this.servletPath + "/" + this.pathInfo)));
        }
        return this.aPathInfo;
    }

    public String getRootRelativePathInfo() {
        if (this.rPath == null) {
            this.rPath = this.contextRoot == null ? (this.servletPath == null ? (this.pathInfo == null ? "/" : "/" + this.pathInfo) : (this.pathInfo == null ? "/" + this.servletPath : "/" + this.servletPath + "/" + this.pathInfo)) : (this.servletPath == null ? (this.pathInfo == null ? "/" + this.contextRoot : "/" + this.contextRoot + "/" + this.pathInfo) : (this.pathInfo == null ? "/" + this.contextRoot + "/" + this.servletPath : "/" + this.contextRoot + "/" + this.servletPath + "/" + this.pathInfo));
        }
        return this.rPath;
    }

    public String getAbsolutePathInfoParent() {
        return UriContext.getParent(this.getAbsolutePathInfo());
    }

    public String getRootRelativePathInfoParent() {
        return UriContext.getParent(this.getRootRelativePathInfo());
    }

    private static String getParent(String uri) {
        int i = uri.lastIndexOf(47);
        if (i <= 1) {
            return "/";
        }
        return uri.substring(0, i);
    }

    public String toString() {
        return Json5Serializer.DEFAULT.toString(this);
    }
}

