/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;

public class BeanCreator<T> {
    private final BeanStore store;
    private ClassInfo type;
    private Object builder;
    private T impl;
    private boolean silent;

    public static <T> BeanCreator<T> of(Class<T> beanType) {
        return BeanStore.INSTANCE.createBean(beanType);
    }

    protected BeanCreator(Class<T> type, BeanStore store) {
        this.type = ClassInfo.of(type);
        this.store = BeanStore.of(store, store.outer.orElse(null));
    }

    public BeanCreator<T> type(Class<?> value) {
        this.type = ClassInfo.of(value);
        return this;
    }

    public BeanCreator<T> type(ClassInfo value) {
        return this.type(value == null ? null : value.inner());
    }

    public BeanCreator<T> impl(T value) {
        this.impl = value;
        return this;
    }

    public <T2> BeanCreator<T> arg(Class<T2> beanType, T2 bean) {
        this.store.add(beanType, bean);
        return this;
    }

    public BeanCreator<T> silent() {
        this.silent = true;
        return this;
    }

    public <B> BeanCreator<T> builder(Class<B> type, B value) {
        this.builder = value;
        Class<?> t = value.getClass();
        do {
            this.store.add(t, value);
        } while ((t = t.getSuperclass()) != null && !t.equals(type));
        return this;
    }

    public T orElse(T other) {
        return this.execute().orElse(other);
    }

    public Optional<T> execute() {
        return CollectionUtils.optional(this.silent().run());
    }

    public T run() {
        MethodInfo m;
        if (this.impl != null) {
            return this.impl;
        }
        if (this.type == null) {
            return null;
        }
        Value found = Value.empty();
        if (this.builder != null && (m = this.type.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasNumParams(1) && x.getParam(0).canAccept(this.builder) && x.hasReturnType(this.type) && x.hasNoAnnotation(BeanIgnore.class) && x.hasName("getInstance"))) != null) {
            return m.invoke(null, this.builder);
        }
        if (this.builder == null && (m = this.type.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasNoParams() && x.hasReturnType(this.type) && x.hasNoAnnotation(BeanIgnore.class) && x.hasName("getInstance"))) != null) {
            return m.invoke(null, new Object[0]);
        }
        if (this.builder == null) {
            Match match = new Match();
            this.type.forEachPublicMethod(x -> this.isStaticCreateMethod((MethodInfo)x), x -> {
                found.set("STATIC_CREATOR");
                if (this.hasAllParams((ExecutableInfo)x)) {
                    match.add(x);
                }
            });
            if (match.isPresent()) {
                return ((MethodInfo)match.get()).invoke(null, this.getParams((ExecutableInfo)match.get()));
            }
        }
        if (this.type.isInterface()) {
            if (this.silent) {
                return null;
            }
            throw new ExecutableException("Could not instantiate class {0}: {1}.", this.type.getName(), "Class is an interface");
        }
        if (this.type.isAbstract()) {
            if (this.silent) {
                return null;
            }
            throw new ExecutableException("Could not instantiate class {0}: {1}.", this.type.getName(), "Class is abstract");
        }
        Match constructorMatch = new Match();
        this.type.forEachPublicConstructor(x -> true, x -> {
            found.setIfEmpty("PUBLIC_CONSTRUCTOR");
            if (this.hasAllParams((ExecutableInfo)x)) {
                constructorMatch.add(x);
            }
        });
        if (!constructorMatch.isPresent()) {
            this.type.forEachDeclaredConstructor(ExecutableInfo::isProtected, x -> {
                found.setIfEmpty("PROTECTED_CONSTRUCTOR");
                if (this.hasAllParams((ExecutableInfo)x)) {
                    constructorMatch.add(x);
                }
            });
        }
        if (constructorMatch.isPresent()) {
            return ((ConstructorInfo)constructorMatch.get()).invoke(this.getParams((ExecutableInfo)constructorMatch.get()));
        }
        if (this.builder == null) {
            Value value = Value.empty();
            this.type.forEachDeclaredConstructor(x -> x.hasNumParams(1) && x.isVisible(Visibility.PROTECTED), x -> {
                Class pt = x.getParam(0).getParameterType().inner();
                MethodInfo m = this.type.getPublicMethod(y -> this.isStaticCreateMethod((MethodInfo)y, pt));
                if (m != null) {
                    Object builder = m.invoke(null, new Object[0]);
                    value.set(x.accessible().invoke(builder));
                }
            });
            if (value.isPresent()) {
                return value.get();
            }
        }
        if (this.silent) {
            return null;
        }
        Object msg = null;
        msg = found.isEmpty() ? "No public/protected constructors found" : (((String)found.get()).equals("STATIC_CREATOR") ? "Static creator found but could not find prerequisites: " + this.type.getPublicMethods().stream().filter(x -> this.isStaticCreateMethod((MethodInfo)x)).map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or ")) : (((String)found.get()).equals("PUBLIC_CONSTRUCTOR") ? "Public constructor found but could not find prerequisites: " + this.type.getPublicConstructors().stream().map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or ")) : "Protected constructor found but could not find prerequisites: " + this.type.getDeclaredConstructors().stream().filter(ExecutableInfo::isProtected).map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or "))));
        throw new ExecutableException("Could not instantiate class {0}: {1}.", this.type.getName(), msg);
    }

    public Supplier<T> supplier() {
        return () -> this.run();
    }

    private boolean isStaticCreateMethod(MethodInfo m) {
        return this.isStaticCreateMethod(m, this.type.inner());
    }

    private boolean isStaticCreateMethod(MethodInfo m, Class<?> type) {
        return m.isStatic() && m.isNotDeprecated() && m.hasReturnType(type) && m.hasNoAnnotation(BeanIgnore.class) && m.hasName("create");
    }

    private boolean hasAllParams(ExecutableInfo ei) {
        return this.store.hasAllParams(ei);
    }

    private Object[] getParams(ExecutableInfo ei) {
        return this.store.getParams(ei);
    }

    private String getMissingParams(ExecutableInfo ei) {
        return this.store.getMissingParams(ei);
    }

    static class Match<T extends ExecutableInfo> {
        T executable = null;
        int numMatches = -1;

        Match() {
        }

        void add(T ei) {
            if (((ExecutableInfo)ei).getParamCount() > this.numMatches) {
                this.numMatches = ((ExecutableInfo)ei).getParamCount();
                this.executable = ((ExecutableInfo)ei).accessible();
            }
        }

        boolean isPresent() {
            return this.executable != null;
        }

        T get() {
            return this.executable;
        }
    }
}

