/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connection.utils;

import java.util.Arrays;
import java.util.Set;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.ops4j.pax.transx.connection.utils.UserPasswordConnectionRequestInfo;
import org.ops4j.pax.transx.connection.utils.UserPasswordManagedConnectionFactory;

public class CredentialExtractor {
    private final String userName;
    private final String password;

    public CredentialExtractor(Subject subject, ConnectionRequestInfo connectionRequestInfo, UserPasswordManagedConnectionFactory managedConnectionFactory) throws ResourceAdapterInternalException {
        assert (managedConnectionFactory != null);
        if (connectionRequestInfo != null && !(connectionRequestInfo instanceof UserPasswordConnectionRequestInfo)) {
            throw new ResourceAdapterInternalException("ConnectionRequestInfo must be a UserPasswordConnectionRequestInfo, not a " + connectionRequestInfo.getClass().getName());
        }
        if (subject != null) {
            Set<PasswordCredential> credentials = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : credentials) {
                if (!managedConnectionFactory.equals(passwordCredential.getManagedConnectionFactory())) continue;
                this.userName = passwordCredential.getUserName();
                this.password = new String(passwordCredential.getPassword());
                return;
            }
            throw new ResourceAdapterInternalException("No credential found for this ManagedConnectionFactory: " + managedConnectionFactory);
        }
        if (connectionRequestInfo != null && ((UserPasswordConnectionRequestInfo)connectionRequestInfo).getUserName() != null) {
            this.userName = ((UserPasswordConnectionRequestInfo)connectionRequestInfo).getUserName();
            this.password = ((UserPasswordConnectionRequestInfo)connectionRequestInfo).getPassword();
            return;
        }
        this.userName = managedConnectionFactory.getUserName();
        this.password = managedConnectionFactory.getPassword();
    }

    public boolean matches(Subject subject, UserPasswordConnectionRequestInfo connectionRequestInfo, UserPasswordManagedConnectionFactory managedConnectionFactory) throws ResourceAdapterInternalException {
        assert (managedConnectionFactory != null);
        if (subject != null) {
            Set<PasswordCredential> credentials = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : credentials) {
                if (!managedConnectionFactory.equals(passwordCredential.getManagedConnectionFactory())) continue;
                return this.userName == null ? passwordCredential.getUserName() == null : this.userName.equals(passwordCredential.getUserName()) && (this.password == null ? passwordCredential.getPassword() == null : Arrays.equals(this.password.toCharArray(), passwordCredential.getPassword()));
            }
            throw new ResourceAdapterInternalException("No credential found for this ManagedConnectionFactory: " + managedConnectionFactory);
        }
        if (connectionRequestInfo != null && connectionRequestInfo.getUserName() != null) {
            return this.userName.equals(connectionRequestInfo.getUserName()) && (this.password == null ? connectionRequestInfo.getPassword() == null : this.password.equals(connectionRequestInfo.getPassword()));
        }
        return this.userName == null ? managedConnectionFactory.getUserName() == null : this.userName.equals(managedConnectionFactory.getUserName()) && (this.password == null ? managedConnectionFactory.getPassword() == null : this.password.equals(managedConnectionFactory.getPassword()));
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

