/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io.stream;

import com.jmatio.io.stream.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferedOutputStream
extends BufferedOutputStream {
    private ByteBuffer buffer;
    private boolean onHeap;
    private float increasing = 1.5f;
    public static final float DEFAULT_INCREASING_FACTOR = 1.5f;

    public ByteBufferedOutputStream(int size) {
        this(size, 1.5f, false);
    }

    public ByteBufferedOutputStream(int size, boolean onHeap) {
        this(size, 1.5f, onHeap);
    }

    public ByteBufferedOutputStream(int size, float increasingBy) {
        this(size, increasingBy, false);
    }

    public ByteBufferedOutputStream(int size, float increasingBy, boolean onHeap) {
        if (increasingBy <= 1.0f) {
            throw new IllegalArgumentException("Increasing Factor must be greater than 1.0");
        }
        this.buffer = onHeap ? ByteBuffer.allocate(size) : ByteBuffer.allocateDirect(size);
        this.onHeap = onHeap;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int limit;
        int position = this.buffer.position();
        long newTotal = position + len;
        if (newTotal > (long)(limit = this.buffer.limit())) {
            int capacity = (int)((float)this.buffer.capacity() * this.increasing);
            while ((long)capacity <= newTotal) {
                capacity = (int)((float)capacity * this.increasing);
            }
            this.increase(capacity);
        }
        this.buffer.put(b, 0, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.increase((int)((float)this.buffer.capacity() * this.increasing));
        }
        this.buffer.put((byte)b);
    }

    protected void increase(int newCapacity) {
        this.buffer.limit(this.buffer.position());
        this.buffer.rewind();
        ByteBuffer newBuffer = this.onHeap ? ByteBuffer.allocate(newCapacity) : ByteBuffer.allocateDirect(newCapacity);
        newBuffer.put(this.buffer);
        this.buffer.clear();
        this.buffer = newBuffer;
    }

    @Override
    public long size() {
        return this.buffer.position();
    }

    public long capacity() {
        return this.buffer.capacity();
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer;
    }
}

