/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.http.ChecksumExtractor;
import org.eclipse.aether.transport.http.HttpTransporter;
import org.eclipse.aether.transport.http.Nexus2ChecksumExtractor;
import org.eclipse.aether.transport.http.XChecksumChecksumExtractor;

@Named(value="http")
public final class HttpTransporterFactory
implements TransporterFactory {
    public static final String NAME = "http";
    private float priority = 5.0f;
    private final Map<String, ChecksumExtractor> extractors;

    private static Map<String, ChecksumExtractor> getManuallyCreatedExtractors() {
        HashMap<String, ChecksumExtractor> map = new HashMap<String, ChecksumExtractor>();
        map.put("nexus2", new Nexus2ChecksumExtractor());
        map.put("x-checksum", new XChecksumChecksumExtractor());
        return Collections.unmodifiableMap(map);
    }

    @Deprecated
    public HttpTransporterFactory() {
        this(HttpTransporterFactory.getManuallyCreatedExtractors());
    }

    @Inject
    public HttpTransporterFactory(Map<String, ChecksumExtractor> extractors) {
        this.extractors = Objects.requireNonNull(extractors);
    }

    public float getPriority() {
        return this.priority;
    }

    public HttpTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new HttpTransporter(this.extractors, repository, session);
    }
}

