/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.state.presence;

import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.state.presence.AbstractBaseCache;
import org.apache.vysper.xmpp.state.presence.PresenceCachingException;

public class EhCachePresenceCacheImpl
extends AbstractBaseCache {
    private static final String PRESENCE_CACHE = "PresenceCache";
    private static final String JID_PRESENCE_CACHE = "JIDCache";
    private Cache presenceCache = null;
    private Cache jidPresenceCache = null;
    private static final String DEFAULT_EHCACHE_CONFIG_FILE = "/ehcache.xml";

    public EhCachePresenceCacheImpl(String configFile) {
        this.createCache(configFile);
    }

    protected void createCache(String configFile) {
        URL configFileURL;
        if (configFile == null) {
            configFile = DEFAULT_EHCACHE_CONFIG_FILE;
        }
        if ((configFileURL = this.getClass().getResource(configFile)) == null) {
            throw new RuntimeException("ehcache configuration file ehcache.xml not found on classpath");
        }
        CacheManager.create();
        this.presenceCache = CacheManager.getInstance().getCache(PRESENCE_CACHE);
        this.jidPresenceCache = CacheManager.getInstance().getCache(JID_PRESENCE_CACHE);
    }

    protected void put0(Entity entity, PresenceStanza presenceStanza) throws PresenceCachingException {
        Element cacheElement = new Element((Object)entity, (Object)presenceStanza);
        Element jidElement = new Element((Object)entity.getBareJID(), (Object)presenceStanza);
        this.presenceCache.put(cacheElement);
        this.jidPresenceCache.put(jidElement);
    }

    protected PresenceStanza get0(Entity entity) throws PresenceCachingException {
        Element cacheElement = this.presenceCache.get((Object)entity);
        if (cacheElement != null) {
            return (PresenceStanza)((Object)cacheElement.getObjectValue());
        }
        return null;
    }

    public PresenceStanza getForBareJID(Entity entity) throws PresenceCachingException {
        if (entity == null) {
            return null;
        }
        Element cacheElement = this.jidPresenceCache.get((Object)entity);
        if (cacheElement != null) {
            return (PresenceStanza)((Object)cacheElement.getObjectValue());
        }
        return null;
    }

    public void remove(Entity entity) {
        if (entity == null) {
            return;
        }
        this.presenceCache.remove((Object)entity);
        this.jidPresenceCache.remove((Object)entity.getBareJID());
    }
}

