/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLElementBuilder<B extends AbstractXMLElementBuilder, T extends XMLElement> {
    private Stack<ElementStruct> stack = new Stack();
    protected ElementStruct currentElement = null;
    private XMLElement resultingElement = null;
    private boolean isReset = false;

    public AbstractXMLElementBuilder(String elementName) {
        this(elementName, null);
    }

    public AbstractXMLElementBuilder(String elementName, String namespaceURI) {
        this(elementName, namespaceURI, null);
    }

    public AbstractXMLElementBuilder(String elementName, String namespaceURI, String namespacePrefix) {
        this.startNewElement(elementName, namespaceURI, namespacePrefix);
        this.resultingElement = this.currentElement.element;
        this.stack.push(this.currentElement);
    }

    public AbstractXMLElementBuilder(String elementName, String namespaceURI, String namespacePrefix, List<Attribute> attributes, Map<String, String> namespaces, List<XMLFragment> innerFragments) {
        this.startNewElement(elementName, namespaceURI, namespacePrefix);
        this.resultingElement = this.currentElement.element;
        if (attributes != null) {
            this.currentElement.attributes.addAll(attributes);
        }
        if (namespaces != null) {
            this.currentElement.namespaces.putAll(namespaces);
        }
        if (innerFragments != null) {
            this.currentElement.innerFragments.addAll(innerFragments);
        }
        this.stack.push(this.currentElement);
    }

    protected XMLElement createElement(String namespaceURI, String name, String namespacePrefix, List<Attribute> attributes, Map<String, String> namespaces, List<XMLFragment> innerFragments) {
        return new XMLElement(namespaceURI, name, namespacePrefix, attributes, innerFragments, namespaces);
    }

    public void startNewElement(String name, String namespaceURI, String namespacePrefix) {
        ElementStruct element = new ElementStruct();
        element.attributes = new ArrayList<Attribute>();
        element.namespaces = new HashMap<String, String>();
        if (namespacePrefix == null) {
            namespacePrefix = "";
        }
        if (namespaceURI != null && namespacePrefix.length() > 0) {
            element.namespaces.put(namespacePrefix, namespaceURI);
        }
        element.innerFragments = new ArrayList<XMLFragment>();
        element.element = this.createElement(namespaceURI, name, namespacePrefix, element.attributes, element.namespaces, element.innerFragments);
        this.currentElement = element;
    }

    public B declareNamespace(String namespacePrefix, String value) {
        if (this.currentElement.namespaces.containsValue(value)) {
            for (Map.Entry<String, String> ns : this.currentElement.namespaces.entrySet()) {
                if (!ns.getValue().equals(value)) continue;
                this.currentElement.namespaces.remove(ns.getKey());
            }
        }
        this.currentElement.namespaces.put(namespacePrefix, value);
        return (B)this;
    }

    public B addAttribute(String name, String value) {
        this.addAttribute(new Attribute(name, value));
        return (B)this;
    }

    public B addAttribute(String namespaceUris, String name, String value) {
        this.addAttribute(new Attribute(namespaceUris, name, value));
        return (B)this;
    }

    public B addAttribute(Attribute attribute) {
        this.checkReset();
        for (Attribute existing : this.currentElement.attributes) {
            if (!existing.getName().equals(attribute.getName()) || !existing.getNamespaceUri().equals(attribute.getNamespaceUri())) continue;
            this.currentElement.attributes.remove(existing);
            break;
        }
        this.currentElement.attributes.add(attribute);
        return (B)this;
    }

    public B addText(String text) {
        this.checkReset();
        this.currentElement.innerFragments.add(new XMLText(text));
        return (B)this;
    }

    public B startInnerElement(String name) {
        return this.startInnerElement(name, null);
    }

    public B startInnerElement(String name, String namespaceURI) {
        this.checkReset();
        this.startNewElement(name, namespaceURI, null);
        this.stack.peek().innerFragments.add(this.currentElement.element);
        this.stack.push(this.currentElement);
        return (B)this;
    }

    public B endInnerElement() {
        this.checkReset();
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("cannot end beyond top element");
        }
        this.stack.pop();
        this.currentElement = this.stack.peek();
        return (B)this;
    }

    public B addPreparedElement(XMLElement preparedElement) {
        this.checkReset();
        this.currentElement.innerFragments.add(preparedElement);
        return (B)this;
    }

    public T build() {
        this.checkReset();
        XMLElement returnStanza = this.resultingElement;
        this.resultingElement = null;
        this.isReset = true;
        this.stack.clear();
        return (T)returnStanza;
    }

    private void checkReset() {
        if (this.isReset) {
            throw new IllegalStateException("XML element builder was reset after retrieving stanza");
        }
    }

    class ElementStruct {
        public ElementStruct parentElement = null;
        public XMLElement element = null;
        public List<Attribute> attributes = null;
        public Map<String, String> namespaces = null;
        public List<XMLFragment> innerFragments = null;

        ElementStruct() {
        }
    }
}

