/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext
extends Timer.Task {
    private static final Logger log = LoggerFactory.getLogger((Class)TransactionContext.class);
    private static final int STATUS_PREPARING = 1;
    private static final int STATUS_PREPARED = 2;
    private static final int STATUS_COMMITTING = 3;
    private static final int STATUS_COMMITTED = 4;
    private static final int STATUS_ROLLING_BACK = 5;
    private static final int STATUS_ROLLED_BACK = 6;
    private static ThreadLocal CURRENT_XID = new ThreadLocal();
    private static final Timer TIMER = new Timer(true);
    private final InternalXAResource[] resources;
    private final int timeout;
    private final Xid xid;
    private final Map attributes = new HashMap();
    private int status;
    private boolean suspended;

    public TransactionContext(Xid xid, InternalXAResource[] resources, int timeout) {
        this.xid = xid;
        this.resources = resources;
        this.timeout = timeout;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public synchronized void prepare() throws XAException {
        this.bindCurrentXid();
        this.status = 1;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            try {
                this.resources[i].prepare(this);
                continue;
            }
            catch (TransactionException e) {
                txe = e;
                break;
            }
        }
        this.afterOperation();
        this.status = 2;
        if (txe != null) {
            try {
                this.rollback();
            }
            catch (XAException e) {
                // empty catch block
            }
            XAException e = new XAException(104);
            e.initCause((Throwable)((Object)txe));
            throw e;
        }
        TIMER.schedule((Timer.Task)this, (long)(this.timeout * 1000), Integer.MAX_VALUE);
    }

    public synchronized void commit() throws XAException {
        if (this.status == 6) {
            throw new XAException(106);
        }
        this.bindCurrentXid();
        this.status = 3;
        this.beforeOperation();
        TransactionException txe = null;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            if (txe != null) {
                try {
                    resource.rollback(this);
                }
                catch (TransactionException e) {
                    log.warn("Unable to rollback changes on " + resource, (Throwable)((Object)e));
                }
                continue;
            }
            try {
                resource.commit(this);
                continue;
            }
            catch (TransactionException e) {
                txe = e;
            }
        }
        this.afterOperation();
        this.status = 4;
        this.cancel();
        this.cleanCurrentXid();
        if (txe != null) {
            XAException e = new XAException(104);
            e.initCause((Throwable)((Object)txe));
            throw e;
        }
    }

    public synchronized void rollback() throws XAException {
        if (this.status == 6) {
            throw new XAException(106);
        }
        this.bindCurrentXid();
        this.status = 5;
        this.beforeOperation();
        int errors = 0;
        for (int i = 0; i < this.resources.length; ++i) {
            InternalXAResource resource = this.resources[i];
            try {
                resource.rollback(this);
                continue;
            }
            catch (TransactionException e) {
                log.warn("Unable to rollback changes on " + resource, (Throwable)((Object)e));
                ++errors;
            }
        }
        this.afterOperation();
        this.status = 6;
        this.cancel();
        this.cleanCurrentXid();
        if (errors != 0) {
            throw new XAException(104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TransactionContext transactionContext = this;
        synchronized (transactionContext) {
            if (this.status == 2) {
                try {
                    this.rollback();
                }
                catch (XAException xAException) {
                    // empty catch block
                }
                log.warn("Transaction rolled back because timeout expired.");
            }
            this.cancel();
        }
    }

    private void beforeOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].beforeOperation(this);
        }
    }

    private void afterOperation() {
        for (int i = 0; i < this.resources.length; ++i) {
            this.resources[i].afterOperation(this);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    private void bindCurrentXid() {
        CURRENT_XID.set(this.xid);
    }

    private void cleanCurrentXid() {
        CURRENT_XID.set(null);
    }

    public static Xid getCurrentXid() {
        return (Xid)CURRENT_XID.get();
    }

    public static boolean isCurrentXid(Xid xid, boolean fallback) {
        Xid currentXid = (Xid)CURRENT_XID.get();
        return fallback ? true : (currentXid == null || xid == null ? fallback : Arrays.equals(xid.getGlobalTransactionId(), currentXid.getGlobalTransactionId()));
    }
}

