/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public abstract class AttachedObjectTargetHandler<T extends AttachedObjectTarget>
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(AttachedObjectTargetHandler.class.getName());
    protected final TagAttribute _name = this.getRequiredAttribute("name");
    protected final TagAttribute _targets = this.getAttribute("targets");
    private boolean _cacheable = this._name.isLiteral();
    private AttachedObjectTarget _target;

    public AttachedObjectTargetHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
        if (beanInfo == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
            }
            return;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        ArrayList<AttachedObjectTarget> targetList = (ArrayList<AttachedObjectTarget>)beanDescriptor.getValue("jakarta.faces.view.AttachedObjectTargets");
        if (targetList == null) {
            targetList = new ArrayList<AttachedObjectTarget>(5);
            beanDescriptor.setValue("jakarta.faces.view.AttachedObjectTargets", targetList);
        }
        if (this.isCacheable()) {
            if (this._target == null) {
                this._target = this.createAttachedObjectTarget(ctx);
            }
            targetList.add(this._target);
        } else {
            T target = this.createAttachedObjectTarget(ctx);
            targetList.add((AttachedObjectTarget)target);
        }
        this.nextHandler.apply(ctx, parent);
    }

    @Override
    public boolean isCacheable() {
        return this._cacheable;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
    }

    protected abstract T createAttachedObjectTarget(FaceletContext var1);
}

