/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.IOException;
import jpt.sun.tools.classfile.AccessFlags;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.ClassReader;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;

public class InnerClasses_attribute
extends Attribute {
    public final int number_of_classes;
    public final Info[] classes;

    InnerClasses_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        this.number_of_classes = cr.readUnsignedShort();
        this.classes = new Info[this.number_of_classes];
        for (int i = 0; i < this.number_of_classes; ++i) {
            this.classes[i] = new Info(cr);
        }
    }

    public InnerClasses_attribute(ConstantPool constant_pool, Info[] classes) throws ConstantPoolException {
        this(constant_pool.getUTF8Index("InnerClasses"), classes);
    }

    public InnerClasses_attribute(int name_index, Info[] classes) {
        super(name_index, 2 + Info.length() * classes.length);
        this.number_of_classes = classes.length;
        this.classes = classes;
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitInnerClasses(this, data);
    }

    public static class Info {
        public final int inner_class_info_index;
        public final int outer_class_info_index;
        public final int inner_name_index;
        public final AccessFlags inner_class_access_flags;

        Info(ClassReader cr) throws IOException {
            this.inner_class_info_index = cr.readUnsignedShort();
            this.outer_class_info_index = cr.readUnsignedShort();
            this.inner_name_index = cr.readUnsignedShort();
            this.inner_class_access_flags = new AccessFlags(cr.readUnsignedShort());
        }

        public Info(int inner_class_info_index, int outer_class_info_index, int inner_name_index, AccessFlags inner_class_access_flags) {
            this.inner_class_info_index = inner_class_info_index;
            this.outer_class_info_index = outer_class_info_index;
            this.inner_name_index = inner_name_index;
            this.inner_class_access_flags = inner_class_access_flags;
        }

        public ConstantPool.CONSTANT_Class_info getInnerClassInfo(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.inner_class_info_index == 0) {
                return null;
            }
            return constant_pool.getClassInfo(this.inner_class_info_index);
        }

        public ConstantPool.CONSTANT_Class_info getOuterClassInfo(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.outer_class_info_index == 0) {
                return null;
            }
            return constant_pool.getClassInfo(this.outer_class_info_index);
        }

        public String getInnerName(ConstantPool constant_pool) throws ConstantPoolException {
            if (this.inner_name_index == 0) {
                return null;
            }
            return constant_pool.getUTF8Value(this.inner_name_index);
        }

        public static int length() {
            return 8;
        }
    }
}

