/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkSPI;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import org.jetbrains.annotations.Nullable;

public class RecordSinkFactory {
    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, ColumnFilter columnFilter, boolean symAsString) {
        return RecordSinkFactory.getInstance(asm, columnTypes, columnFilter, symAsString, null);
    }

    public static RecordSink getInstance(BytecodeAssembler asm, ColumnTypes columnTypes, ColumnFilter columnFilter, boolean symAsString, @Nullable IntList skewIndex) {
        asm.init(RecordSink.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/cairo/sink"));
        int interfaceClassIndex = asm.poolClass(RecordSink.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetGeoInt = asm.poolInterfaceMethod(Record.class, "getGeoInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetGeoLong = asm.poolInterfaceMethod(Record.class, "getGeoLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetLong128Lo = asm.poolInterfaceMethod(Record.class, "getLong128Lo", "(I)J");
        int rGetLong128Hi = asm.poolInterfaceMethod(Record.class, "getLong128Hi", "(I)J");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetGeoByte = asm.poolInterfaceMethod(Record.class, "getGeoByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetGeoShort = asm.poolInterfaceMethod(Record.class, "getGeoShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetStr = asm.poolInterfaceMethod(Record.class, "getStr", "(I)Ljava/lang/CharSequence;");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSym", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int rGetRecord = asm.poolInterfaceMethod(Record.class, "getRecord", "(I)Lio/questdb/cairo/sql/Record;");
        int wPutInt = asm.poolInterfaceMethod(RecordSinkSPI.class, "putInt", "(I)V");
        int wSkip = asm.poolInterfaceMethod(RecordSinkSPI.class, "skip", "(I)V");
        int wPutLong = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong", "(J)V");
        int wPutLong256 = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong256", "(Lio/questdb/std/Long256;)V");
        int wPutLong128 = asm.poolInterfaceMethod(RecordSinkSPI.class, "putLong128", "(JJ)V");
        int wPutByte = asm.poolInterfaceMethod(RecordSinkSPI.class, "putByte", "(B)V");
        int wPutShort = asm.poolInterfaceMethod(RecordSinkSPI.class, "putShort", "(S)V");
        int wPutChar = asm.poolInterfaceMethod(RecordSinkSPI.class, "putChar", "(C)V");
        int wPutBool = asm.poolInterfaceMethod(RecordSinkSPI.class, "putBool", "(Z)V");
        int wPutFloat = asm.poolInterfaceMethod(RecordSinkSPI.class, "putFloat", "(F)V");
        int wPutDouble = asm.poolInterfaceMethod(RecordSinkSPI.class, "putDouble", "(D)V");
        int wPutStr = asm.poolInterfaceMethod(RecordSinkSPI.class, "putStr", "(Ljava/lang/CharSequence;)V");
        int wPutDate = asm.poolInterfaceMethod(RecordSinkSPI.class, "putDate", "(J)V");
        int wPutTimestamp = asm.poolInterfaceMethod(RecordSinkSPI.class, "putTimestamp", "(J)V");
        int wPutBin = asm.poolInterfaceMethod(RecordSinkSPI.class, "putBin", "(Lio/questdb/std/BinarySequence;)V");
        int wPutRecord = asm.poolInterfaceMethod(RecordSinkSPI.class, "putRecord", "(Lio/questdb/cairo/sql/Record;)V");
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/RecordSinkSPI;)V");
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(0);
        asm.methodCount(2);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 7, 5);
        int n = columnFilter.getColumnCount();
        block24: for (int i = 0; i < n; ++i) {
            int index = columnFilter.getColumnIndex(i);
            int factor = columnFilter.getIndexFactor(index);
            index = index * factor - 1;
            int type = columnTypes.getColumnType(index);
            switch (factor * ColumnType.tagOf(type)) {
                case 5: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block24;
                }
                case 12: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    if (symAsString) {
                        asm.invokeInterface(rGetSym, 1);
                        asm.invokeInterface(wPutStr, 1);
                        continue block24;
                    }
                    asm.invokeInterface(rGetInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block24;
                }
                case 6: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block24;
                }
                case 7: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetDate, 1);
                    asm.invokeInterface(wPutDate, 2);
                    continue block24;
                }
                case 8: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetTimestamp, 1);
                    asm.invokeInterface(wPutTimestamp, 2);
                    continue block24;
                }
                case 2: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block24;
                }
                case 3: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block24;
                }
                case 4: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetChar, 1);
                    asm.invokeInterface(wPutChar, 1);
                    continue block24;
                }
                case 1: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetBool, 1);
                    asm.invokeInterface(wPutBool, 1);
                    continue block24;
                }
                case 9: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetFloat, 1);
                    asm.invokeInterface(wPutFloat, 1);
                    continue block24;
                }
                case 10: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetDouble, 1);
                    asm.invokeInterface(wPutDouble, 2);
                    continue block24;
                }
                case 11: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetStr, 1);
                    asm.invokeInterface(wPutStr, 1);
                    continue block24;
                }
                case 18: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetBin, 1);
                    asm.invokeInterface(wPutBin, 1);
                    continue block24;
                }
                case 13: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetLong256, 1);
                    asm.invokeInterface(wPutLong256, 1);
                    continue block24;
                }
                case 22: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetRecord, 1);
                    asm.invokeInterface(wPutRecord, 1);
                    continue block24;
                }
                case -5: {
                    asm.aload(2);
                    asm.iconst(4);
                    asm.invokeInterface(wSkip, 1);
                    continue block24;
                }
                case -6: {
                    asm.aload(2);
                    asm.iconst(8);
                    asm.invokeInterface(wSkip, 1);
                    continue block24;
                }
                case 14: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoByte, 1);
                    asm.invokeInterface(wPutByte, 1);
                    continue block24;
                }
                case 15: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoShort, 1);
                    asm.invokeInterface(wPutShort, 1);
                    continue block24;
                }
                case 16: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoInt, 1);
                    asm.invokeInterface(wPutInt, 1);
                    continue block24;
                }
                case 17: {
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(RecordSinkFactory.getSkewedIndex(index, skewIndex));
                    asm.invokeInterface(rGetGeoLong, 1);
                    asm.invokeInterface(wPutLong, 2);
                    continue block24;
                }
                case 19: 
                case 24: {
                    int skewedIndex = RecordSinkFactory.getSkewedIndex(index, skewIndex);
                    asm.aload(2);
                    asm.aload(1);
                    asm.iconst(skewedIndex);
                    asm.invokeInterface(rGetLong128Lo, 1);
                    asm.aload(1);
                    asm.iconst(skewedIndex);
                    asm.invokeInterface(rGetLong128Hi, 1);
                    asm.invokeInterface(wPutLong128, 4);
                    continue block24;
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordSink)asm.newInstance();
    }

    private static int getSkewedIndex(int src, @Nullable IntList skewIndex) {
        if (skewIndex == null) {
            return src;
        }
        return skewIndex.getQuick(src);
    }
}

