/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationActions;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

final class Mig506 {
    private static final String TXN_FILE_NAME = "_txn";
    private static final long TX_OFFSET_TRANSIENT_ROW_COUNT = 8L;
    private static final long TX_OFFSET_FIXED_ROW_COUNT_64 = 16L;
    private static final long TX_OFFSET_MIN_TIMESTAMP = 24L;
    private static final long TX_OFFSET_MAX_TIMESTAMP = 32L;
    private static final String TX_STRUCT_UPDATE_1_ARCHIVE_FILE_NAME = "_archive";
    private static final long TX_STRUCT_UPDATE_1_META_OFFSET_PARTITION_BY = 4L;

    Mig506() {
    }

    private static boolean removedPartitionsIncludes(long ts, MemoryR txMem, int symbolsCount) {
        long removedPartitionLo = MigrationActions.prefixedBlockOffset(72L, (long)symbolsCount + 1L, 4L);
        long removedPartitionCount = txMem.getInt(removedPartitionLo);
        long removedPartitionsHi = MigrationActions.prefixedBlockOffset(removedPartitionLo, 8L, removedPartitionCount);
        for (long offset = removedPartitionLo + 4L; offset < removedPartitionsHi; offset += 8L) {
            long removedPartition = txMem.getLong(offset);
            if (removedPartition != ts) continue;
            return true;
        }
        return false;
    }

    private static void writeAttachedPartitions(FilesFacade ff, long tempMem8b, Path path, MemoryMARW txMem, int partitionBy, int symbolsCount, MemoryARW writeTo) {
        int rootLen = path.length();
        long minTimestamp = txMem.getLong(24L);
        long maxTimestamp = txMem.getLong(32L);
        long transientCount = txMem.getLong(8L);
        PartitionBy.PartitionFloorMethod partitionFloorMethod = PartitionBy.getPartitionFloorMethod(partitionBy);
        assert (partitionFloorMethod != null);
        PartitionBy.PartitionAddMethod partitionAddMethod = PartitionBy.getPartitionAddMethod(partitionBy);
        assert (partitionAddMethod != null);
        long tsLimit = partitionFloorMethod.floor(maxTimestamp);
        long ts = partitionFloorMethod.floor(minTimestamp);
        while (ts < tsLimit) {
            path.trimTo(rootLen);
            TableUtils.setPathForPartition(path, partitionBy, ts, false);
            if (ff.exists(path.concat(TX_STRUCT_UPDATE_1_ARCHIVE_FILE_NAME).$()) && !Mig506.removedPartitionsIncludes(ts, txMem, symbolsCount)) {
                long partitionSize = TableUtils.readLongAtOffset(ff, path, tempMem8b, 0L);
                writeTo.putLong(ts);
                writeTo.putLong(partitionSize);
                writeTo.putLong(-1L);
                writeTo.putLong(0L);
            }
            ts = partitionAddMethod.calculate(ts, 1);
        }
        writeTo.putLong(tsLimit);
        writeTo.putLong(transientCount);
        writeTo.putLong(-1L);
        writeTo.putLong(0L);
    }

    static void migrate(MigrationContext migrationContext) {
        MigrationActions.LOG.info().$("rebuilding tx file [table=").$(migrationContext.getTablePath()).I$();
        Path path = migrationContext.getTablePath();
        FilesFacade ff = migrationContext.getFf();
        int pathDirLen = path.length();
        path.concat(TXN_FILE_NAME).$();
        if (!ff.exists(path)) {
            MigrationActions.LOG.error().$("tx file does not exist, nothing to migrate [path=").$(path).I$();
            return;
        }
        EngineMigration.backupFile(ff, path, migrationContext.getTablePath2(), TXN_FILE_NAME, 417);
        MigrationActions.LOG.debug().$("opening for rw [path=").$(path).I$();
        try (MemoryMARW txMem = migrationContext.createRwMemoryOf(ff, path.$());){
            long writeSize;
            long tempMem8b = migrationContext.getTempMemory(8);
            MemoryARW txFileUpdate = migrationContext.getTempVirtualMem();
            txFileUpdate.jumpTo(0L);
            int symbolColumnCount = txMem.getInt(72L);
            for (int i = 0; i < symbolColumnCount; ++i) {
                int symbolCount = txMem.getInt(MigrationActions.prefixedBlockOffset(72L, (long)i + 1L, 4L));
                txFileUpdate.putInt(symbolCount);
                txFileUpdate.putInt(symbolCount);
            }
            long partitionSegmentOffset = txFileUpdate.getAppendOffset();
            txFileUpdate.putInt(0);
            int partitionBy = TableUtils.readIntOrFail(ff, migrationContext.getMetadataFd(), 4L, tempMem8b, path);
            if (PartitionBy.isPartitioned(partitionBy)) {
                path.trimTo(pathDirLen);
                Mig506.writeAttachedPartitions(ff, tempMem8b, path, txMem, partitionBy, symbolColumnCount, txFileUpdate);
            }
            long updateSize = txFileUpdate.getAppendOffset();
            long partitionSegmentSize = updateSize - partitionSegmentOffset - 4L;
            txFileUpdate.putInt(partitionSegmentOffset, (int)partitionSegmentSize);
            long writeOffset = 76L;
            txMem.jumpTo(writeOffset);
            int size = 1;
            for (int i = 0; i < size && updateSize > 0L; updateSize -= writeSize, ++i) {
                writeSize = Math.min(updateSize, txFileUpdate.getPageSize());
                txMem.putBlockOfBytes(txFileUpdate.getPageAddress(i), writeSize);
            }
            assert (updateSize == 0L);
        }
    }
}

