/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class WalEventReader
implements Closeable {
    private final Log LOG = LogFactory.getLog(WalEventReader.class);
    private final WalEventCursor eventCursor;
    private final MemoryMR eventMem;
    private final FilesFacade ff;

    public WalEventReader(FilesFacade ff) {
        this.ff = ff;
        this.eventMem = Vm.getMRInstance();
        this.eventCursor = new WalEventCursor(this.eventMem);
    }

    @Override
    public void close() {
        Misc.free(this.eventMem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalEventCursor of(Path path, int expectedVersion, long segmentTxn) {
        int trimTo = path.length();
        try {
            long size;
            int fd = TableUtils.openRO(this.ff, path.concat("_event").$(), this.LOG);
            try {
                size = this.ff.readNonNegativeLong(fd, 0L);
            }
            finally {
                this.ff.close(fd);
            }
            if (size < 16L) {
                throw CairoException.critical(0).put("File is too small, size=").put(size).put(", required=").put(12L);
            }
            this.eventMem.of(this.ff, path, this.ff.getPageSize(), size, 36, 0L, -1);
            TableUtils.validateMetaVersion(this.eventMem, 8L, expectedVersion);
            if (this.eventCursor.setPosition(segmentTxn)) {
                WalEventCursor walEventCursor = this.eventCursor;
                return walEventCursor;
            }
            try {
                throw CairoException.critical(0).put("segment does not have txn with id ").put(segmentTxn);
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        }
        finally {
            path.trimTo(trimTo);
        }
    }
}

