/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;

class LatestByValueIndexedFilteredRecordCursor
extends AbstractDataFrameRecordCursor {
    protected final int columnIndex;
    protected final int symbolKey;
    private final Function filter;
    private boolean found;
    private boolean hasNext;

    public LatestByValueIndexedFilteredRecordCursor(int columnIndex, int symbolKey, @NotNull Function filter, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        this.hasNext = this.found;
        this.filter.toTop();
    }

    private void findRecord(SqlExecutionContext executionContext) {
        DataFrame frame;
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        this.found = false;
        while ((frame = this.dataFrameCursor.next()) != null) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            int partitionIndex = frame.getPartitionIndex();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(partitionIndex, 0L);
            RowCursor cursor = indexReader.getCursor(false, this.symbolKey, rowLo, rowHi);
            while (cursor.hasNext()) {
                circuitBreaker.statefulThrowExceptionIfTripped();
                this.recordA.setRecordIndex(cursor.next());
                if (!this.filter.getBool(this.recordA)) continue;
                this.found = true;
                return;
            }
        }
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.filter.init(this, executionContext);
        this.findRecord(executionContext);
        this.hasNext = this.found;
    }
}

