/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.util.FormatUtils;

public class JVMDiagnosticTask
implements DiagnosticTask {
    public DiagnosticsDumpElement captureDump(boolean verbose) {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        ClassLoadingMXBean classLoading = ManagementFactory.getClassLoadingMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        ArrayList<String> details = new ArrayList<String>();
        NumberFormat numberFormat = NumberFormat.getInstance();
        details.add("Total Thread Count: " + numberFormat.format(threads.getThreadCount()));
        details.add("Daemon Thread Count: " + numberFormat.format(threads.getDaemonThreadCount()));
        details.add("Max Heap: " + FormatUtils.formatDataSize((double)heap.getMax()));
        details.add("Heap Used: " + FormatUtils.formatDataSize((double)heap.getUsed()));
        details.add("Heap Committed: " + FormatUtils.formatDataSize((double)heap.getCommitted()));
        details.add("JVM Uptime: " + FormatUtils.formatHoursMinutesSeconds((long)runtime.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS));
        details.add("JVM Spec Name: " + runtime.getSpecName());
        details.add("JVM Spec Vendor: " + runtime.getSpecVendor());
        details.add("JVM Spec Version: " + runtime.getSpecVersion());
        details.add("JVM Vendor: " + runtime.getVmVendor());
        details.add("JVM Version: " + runtime.getVmVersion());
        details.add("Classes Loaded: " + numberFormat.format(classLoading.getLoadedClassCount()));
        details.add("Classes Loaded Since Start: " + numberFormat.format(classLoading.getTotalLoadedClassCount()));
        details.add("Working Directory: " + new File(".").getAbsolutePath());
        return new StandardDiagnosticsDumpElement("Java Virtual Machine", details);
    }
}

