/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.search.SearchableField;

public class SearchableFieldParser {
    public static List<SearchableField> extractSearchableFields(String indexedFieldString, boolean predefinedField) {
        ArrayList<SearchableField> searchableFields = new ArrayList<SearchableField>();
        if (indexedFieldString != null) {
            String[] split;
            for (String fieldName : split = indexedFieldString.split(",")) {
                if ((fieldName = fieldName.trim()).isEmpty()) continue;
                SearchableField searchableField = predefinedField ? SearchableFields.getSearchableField(fieldName) : SearchableFields.newSearchableAttribute(fieldName);
                if (searchableField == null) {
                    throw new RuntimeException("Invalid Configuration: Provenance Repository configured to Index field '" + fieldName + "', but this is not a valid field");
                }
                searchableFields.add(searchableField);
            }
        }
        return searchableFields;
    }
}

