/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.provenance.ProgressiveResult;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardQueryResult
implements QueryResult,
ProgressiveResult {
    private static final Logger logger = LoggerFactory.getLogger(StandardQueryResult.class);
    public static final int TTL = (int)TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
    private final Query query;
    private final long creationNanos;
    private final int numSteps;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final SortedSet<ProvenanceEventRecord> matchingRecords = new TreeSet<ProvenanceEventRecord>(new EventIdComparator());
    private long hitCount = 0L;
    private int numCompletedSteps = 0;
    private Date expirationDate;
    private String error;
    private long queryTime;
    private final Object completionMonitor = new Object();
    private volatile boolean canceled = false;

    public StandardQueryResult(Query query, int numSteps) {
        this.query = query;
        this.numSteps = numSteps;
        this.creationNanos = System.nanoTime();
        this.updateExpiration();
    }

    public List<ProvenanceEventRecord> getMatchingEvents() {
        this.readLock.lock();
        try {
            ArrayList<ProvenanceEventRecord> arrayList = new ArrayList<ProvenanceEventRecord>(this.matchingRecords);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getTotalHitCount() {
        this.readLock.lock();
        try {
            if (this.matchingRecords.size() < this.query.getMaxResults()) {
                long l = this.matchingRecords.size();
                return l;
            }
            long l = this.query.getMaxResults();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public Date getExpiration() {
        return this.expirationDate;
    }

    public String getError() {
        return this.error;
    }

    public int getPercentComplete() {
        this.readLock.lock();
        try {
            int n = this.numSteps < 1 ? 100 : (int)((float)this.numCompletedSteps / (float)this.numSteps * 100.0f);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.numCompletedSteps >= this.numSteps || this.canceled || this.matchingRecords.size() >= this.query.getMaxResults();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setError(String error) {
        this.writeLock.lock();
        try {
            this.error = error;
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps) {
                long searchNanos = System.nanoTime() - this.creationNanos;
                this.queryTime = TimeUnit.MILLISECONDS.convert(searchNanos, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Collection<ProvenanceEventRecord> newEvents, long totalHits) {
        boolean queryComplete = false;
        this.writeLock.lock();
        try {
            if (this.isFinished()) {
                return;
            }
            this.matchingRecords.addAll(newEvents);
            this.hitCount += totalHits;
            if (this.matchingRecords.size() > this.query.getMaxResults()) {
                Iterator itr = this.matchingRecords.iterator();
                for (int i = 0; i < this.query.getMaxResults(); ++i) {
                    itr.next();
                }
                while (itr.hasNext()) {
                    itr.next();
                    itr.remove();
                }
            }
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps || this.matchingRecords.size() >= this.query.getMaxResults()) {
                long searchNanos = System.nanoTime() - this.creationNanos;
                this.queryTime = TimeUnit.MILLISECONDS.convert(searchNanos, TimeUnit.NANOSECONDS);
                queryComplete = true;
                if (this.numCompletedSteps >= this.numSteps) {
                    logger.info("Completed {} comprised of {} steps in {} millis. Index found {} hits. Read {} events from Event Files.", new Object[]{this.query, this.numSteps, this.queryTime, this.hitCount, this.matchingRecords.size()});
                } else {
                    logger.info("Completed {} comprised of {} steps in {} millis. Index found {} hits. Read {} events from Event Files. Only completed {} steps because the maximum number of results was reached.", new Object[]{this.query, this.numSteps, this.queryTime, this.hitCount, this.matchingRecords.size(), this.numCompletedSteps});
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (queryComplete) {
            Object object = this.completionMonitor;
            synchronized (object) {
                this.completionMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCompletion(long time, TimeUnit unit) throws InterruptedException {
        long finishTime = System.currentTimeMillis() + unit.toMillis(time);
        Object object = this.completionMonitor;
        synchronized (object) {
            while (!this.isFinished()) {
                long millisToWait = finishTime - System.currentTimeMillis();
                if (millisToWait > 0L) {
                    this.completionMonitor.wait(millisToWait);
                    continue;
                }
                return this.isFinished();
            }
        }
        return this.isFinished();
    }

    private void updateExpiration() {
        this.expirationDate = new Date(System.currentTimeMillis() + (long)TTL);
    }

    private static class EventIdComparator
    implements Comparator<ProvenanceEventRecord> {
        private EventIdComparator() {
        }

        @Override
        public int compare(ProvenanceEventRecord o1, ProvenanceEventRecord o2) {
            return Long.compare(o2.getEventId(), o1.getEventId());
        }
    }
}

