/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.client.impl.ClientUtils;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoExtensionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersion;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;

public class JerseyExtensionRepoClient
extends AbstractJerseyClient
implements ExtensionRepoClient {
    private WebTarget extensionRepoTarget;

    public JerseyExtensionRepoClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyExtensionRepoClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.extensionRepoTarget = baseTarget.path("extension-repository");
    }

    @Override
    public List<ExtensionRepoBucket> getBuckets() throws IOException, NiFiRegistryException {
        return this.executeAction("Error retrieving buckets for extension repo", () -> {
            ExtensionRepoBucket[] repoBuckets = (ExtensionRepoBucket[])this.getRequestBuilder(this.extensionRepoTarget).get(ExtensionRepoBucket[].class);
            return repoBuckets == null ? Collections.emptyList() : Arrays.asList(repoBuckets);
        });
    }

    @Override
    public List<ExtensionRepoGroup> getGroups(String bucketName) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("Bucket name cannot be null or blank");
        }
        return this.executeAction("Error retrieving groups for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}").resolveTemplate("bucketName", (Object)bucketName);
            ExtensionRepoGroup[] repoGroups = (ExtensionRepoGroup[])this.getRequestBuilder(target).get(ExtensionRepoGroup[].class);
            return repoGroups == null ? Collections.emptyList() : Arrays.asList(repoGroups);
        });
    }

    @Override
    public List<ExtensionRepoArtifact> getArtifacts(String bucketName, String groupId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("Bucket name cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        return this.executeAction("Error retrieving artifacts for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId);
            ExtensionRepoArtifact[] repoArtifacts = (ExtensionRepoArtifact[])this.getRequestBuilder(target).get(ExtensionRepoArtifact[].class);
            return repoArtifacts == null ? Collections.emptyList() : Arrays.asList(repoArtifacts);
        });
    }

    @Override
    public List<ExtensionRepoVersionSummary> getVersions(String bucketName, String groupId, String artifactId) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("Bucket name cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        return this.executeAction("Error retrieving versions for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId);
            ExtensionRepoVersionSummary[] repoVersions = (ExtensionRepoVersionSummary[])this.getRequestBuilder(target).get(ExtensionRepoVersionSummary[].class);
            return repoVersions == null ? Collections.emptyList() : Arrays.asList(repoVersions);
        });
    }

    @Override
    public ExtensionRepoVersion getVersion(String bucketName, String groupId, String artifactId, String version) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        return this.executeAction("Error retrieving versions for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            return (ExtensionRepoVersion)this.getRequestBuilder(target).get(ExtensionRepoVersion.class);
        });
    }

    @Override
    public List<ExtensionRepoExtensionMetadata> getVersionExtensions(String bucketName, String groupId, String artifactId, String version) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        return this.executeAction("Error retrieving versions for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/extensions").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            ExtensionRepoExtensionMetadata[] extensions = (ExtensionRepoExtensionMetadata[])this.getRequestBuilder(target).get(ExtensionRepoExtensionMetadata[].class);
            return extensions == null ? Collections.emptyList() : Arrays.asList(extensions);
        });
    }

    @Override
    public Extension getVersionExtension(String bucketName, String groupId, String artifactId, String version, String extensionName) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            throw new IllegalArgumentException("Extension name is required");
        }
        return this.executeAction("Error retrieving versions for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/extensions/{extensionName}").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version).resolveTemplate("extensionName", (Object)extensionName);
            Extension extension = (Extension)this.getRequestBuilder(target).get(Extension.class);
            return extension;
        });
    }

    @Override
    public InputStream getVersionExtensionDocs(String bucketName, String groupId, String artifactId, String version, String extensionName) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            throw new IllegalArgumentException("Extension name is required");
        }
        return this.executeAction("Error retrieving versions for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/extensions/{extensionName}/docs").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version).resolveTemplate("extensionName", (Object)extensionName);
            return (InputStream)this.getRequestBuilder(target).accept(new String[]{"text/html"}).get().readEntity(InputStream.class);
        });
    }

    @Override
    public InputStream getVersionContent(String bucketName, String groupId, String artifactId, String version) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        return this.executeAction("Error retrieving version content for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/content").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            return (InputStream)this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get().readEntity(InputStream.class);
        });
    }

    @Override
    public File writeBundleVersionContent(String bucketName, String groupId, String artifactId, String version, File directory) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        if (directory == null) {
            throw new IllegalArgumentException("Directory cannot be null");
        }
        return this.executeAction("Error retrieving version content for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/content").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            Response response = this.getRequestBuilder(target).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
            return ClientUtils.getExtensionBundleVersionContent(response, directory);
        });
    }

    @Override
    public String getVersionSha256(String bucketName, String groupId, String artifactId, String version) throws IOException, NiFiRegistryException {
        this.validate(bucketName, groupId, artifactId, version);
        return this.executeAction("Error retrieving version content for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{bucketName}/{groupId}/{artifactId}/{version}/sha256").resolveTemplate("bucketName", (Object)bucketName).resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            return (String)this.getRequestBuilder(target).accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get(String.class);
        });
    }

    @Override
    public Optional<String> getVersionSha256(String groupId, String artifactId, String version) throws IOException, NiFiRegistryException {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        return this.executeAction("Error retrieving version content for extension repo", () -> {
            WebTarget target = this.extensionRepoTarget.path("{groupId}/{artifactId}/{version}/sha256").resolveTemplate("groupId", (Object)groupId).resolveTemplate("artifactId", (Object)artifactId).resolveTemplate("version", (Object)version);
            try {
                String sha256 = (String)this.getRequestBuilder(target).accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).get(String.class);
                return Optional.of(sha256);
            }
            catch (NotFoundException nfe) {
                return Optional.empty();
            }
        });
    }

    private void validate(String bucketName, String groupId, String artifactId, String version) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("Bucket name cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
    }
}

