/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.cryptography.KeyEncryptionKey;
import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClient;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import reactor.core.publisher.Mono;

@ServiceClientBuilder(serviceClients={KeyEncryptionKeyClient.class, KeyEncryptionKeyAsyncClient.class})
public final class KeyEncryptionKeyClientBuilder
implements KeyEncryptionKeyResolver,
AsyncKeyEncryptionKeyResolver,
TokenCredentialTrait<KeyEncryptionKeyClientBuilder>,
HttpTrait<KeyEncryptionKeyClientBuilder>,
ConfigurationTrait<KeyEncryptionKeyClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(KeyEncryptionKeyClientBuilder.class);
    private final CryptographyClientBuilder builder = new CryptographyClientBuilder();

    public KeyEncryptionKey buildKeyEncryptionKey(String keyId) {
        CryptographyServiceVersion serviceVersion;
        this.builder.keyIdentifier(keyId);
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("An Azure Key Vault key identifier cannot be null and is required to build the key encryption key client."));
        }
        CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.builder.getServiceVersion() != null ? this.builder.getServiceVersion() : CryptographyServiceVersion.getLatest();
        if (this.builder.getPipeline() != null) {
            return new KeyEncryptionKeyClient(keyId, this.builder.getPipeline(), serviceVersion);
        }
        if (this.builder.getCredential() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials cannot be null and are required to build a key encryption key client."));
        }
        HttpPipeline pipeline = this.builder.setupPipeline();
        return new KeyEncryptionKeyClient(keyId, pipeline, serviceVersion);
    }

    public KeyEncryptionKey buildKeyEncryptionKey(JsonWebKey key) {
        if (key == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("JSON Web Key cannot be null and is required to build a local key encryption key async client."));
        }
        if (key.getId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("JSON Web Key's id property is not configured."));
        }
        return new KeyEncryptionKeyClient(key);
    }

    public Mono<? extends AsyncKeyEncryptionKey> buildAsyncKeyEncryptionKey(String keyId) {
        CryptographyServiceVersion serviceVersion;
        this.builder.keyIdentifier(keyId);
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("An Azure Key Vault key identifier cannot be null and is required to build the key encryption key client."));
        }
        CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.builder.getServiceVersion() != null ? this.builder.getServiceVersion() : CryptographyServiceVersion.getLatest();
        if (this.builder.getPipeline() != null) {
            return Mono.defer(() -> Mono.just((Object)new KeyEncryptionKeyAsyncClient(keyId, this.builder.getPipeline(), serviceVersion)));
        }
        if (this.builder.getCredential() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials cannot be null and are required to build a key encryption key client."));
        }
        HttpPipeline pipeline = this.builder.setupPipeline();
        return Mono.defer(() -> Mono.just((Object)new KeyEncryptionKeyAsyncClient(keyId, pipeline, serviceVersion)));
    }

    public Mono<? extends AsyncKeyEncryptionKey> buildAsyncKeyEncryptionKey(JsonWebKey key) {
        if (key == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("JSON Web Key cannot be null and is required to build a local key encryption key async client."));
        }
        if (key.getId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("JSON Web Key's id property is not configured."));
        }
        return Mono.defer(() -> Mono.just((Object)new KeyEncryptionKeyAsyncClient(key)));
    }

    public KeyEncryptionKeyClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.builder.credential(credential);
        return this;
    }

    public KeyEncryptionKeyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.builder.httpLogOptions(logOptions);
        return this;
    }

    public KeyEncryptionKeyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        this.builder.addPolicy(policy);
        return this;
    }

    public KeyEncryptionKeyClientBuilder httpClient(HttpClient client) {
        this.builder.httpClient(client);
        return this;
    }

    public KeyEncryptionKeyClientBuilder pipeline(HttpPipeline pipeline) {
        this.builder.pipeline(pipeline);
        return this;
    }

    public KeyEncryptionKeyClientBuilder configuration(Configuration configuration) {
        this.builder.configuration(configuration);
        return this;
    }

    public KeyEncryptionKeyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.builder.serviceVersion(version);
        return this;
    }

    public KeyEncryptionKeyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.builder.retryPolicy(retryPolicy);
        return this;
    }

    public KeyEncryptionKeyClientBuilder retryOptions(RetryOptions retryOptions) {
        this.builder.retryOptions(retryOptions);
        return this;
    }

    public KeyEncryptionKeyClientBuilder clientOptions(ClientOptions clientOptions) {
        this.builder.clientOptions(clientOptions);
        return this;
    }

    public KeyEncryptionKeyClientBuilder disableChallengeResourceVerification() {
        this.builder.disableChallengeResourceVerification();
        return this;
    }
}

