/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bootstrap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.nifi.registry.bootstrap.RunNiFiRegistry;
import org.apache.nifi.registry.bootstrap.exception.InvalidCommandException;

public class BootstrapCodec {
    private final RunNiFiRegistry runner;
    private final BufferedReader reader;
    private final BufferedWriter writer;

    public BootstrapCodec(RunNiFiRegistry runner, InputStream in, OutputStream out) {
        this.runner = runner;
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public void communicate() throws IOException {
        String line = this.reader.readLine();
        String[] splits = line.split(" ");
        if (splits.length < 0) {
            throw new IOException("Received invalid command from NiFi Registry: " + line);
        }
        String cmd = splits[0];
        String[] args = splits.length == 1 ? new String[]{} : Arrays.copyOfRange(splits, 1, splits.length);
        try {
            this.processRequest(cmd, args);
        }
        catch (InvalidCommandException ice) {
            throw new IOException("Received invalid command from NiFi Registry: " + line + (ice.getMessage() == null ? "" : " - Details: " + ice.toString()));
        }
    }

    private void processRequest(String cmd, String[] args) throws InvalidCommandException, IOException {
        switch (cmd) {
            case "PORT": {
                int port;
                if (args.length != 2) {
                    throw new InvalidCommandException();
                }
                try {
                    port = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
                }
                if (port < 1 || port > 65535) {
                    throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
                }
                String secretKey = args[1];
                this.runner.setNiFiRegistryCommandControlPort(port, secretKey);
                this.writer.write("OK");
                this.writer.newLine();
                this.writer.flush();
                break;
            }
            case "STARTED": {
                if (args.length != 1) {
                    throw new InvalidCommandException("STARTED command must contain a status argument");
                }
                if (!"true".equals(args[0]) && !"false".equals(args[0])) {
                    throw new InvalidCommandException("Invalid status for STARTED command; should be true or false, but was '" + args[0] + "'");
                }
                boolean started = Boolean.parseBoolean(args[0]);
                this.runner.setNiFiRegistryStarted(started);
                this.writer.write("OK");
                this.writer.newLine();
                this.writer.flush();
            }
        }
    }
}

