/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.registry.db.entity.KeyEntity;
import org.apache.nifi.registry.db.mapper.KeyEntityRowMapper;
import org.apache.nifi.registry.security.key.Key;
import org.apache.nifi.registry.security.key.KeyService;
import org.apache.nifi.registry.service.mapper.KeyMappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class DatabaseKeyService
implements KeyService {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseKeyService.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public DatabaseKeyService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getKey(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Key key = null;
        this.readLock.lock();
        try {
            KeyEntity keyEntity;
            String sql = "SELECT * FROM SIGNING_KEY WHERE id = ?";
            try {
                keyEntity = (KeyEntity)this.jdbcTemplate.queryForObject("SELECT * FROM SIGNING_KEY WHERE id = ?", (RowMapper)new KeyEntityRowMapper(), new Object[]{id});
            }
            catch (EmptyResultDataAccessException e) {
                keyEntity = null;
            }
            if (keyEntity != null) {
                key = KeyMappings.map(keyEntity);
            } else {
                logger.debug("No signing key found with id='" + id + "'");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getOrCreateKey(String tenantIdentity) {
        Key key;
        if (tenantIdentity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        this.writeLock.lock();
        try {
            KeyEntity existingKeyEntity;
            String selectSql = "SELECT * FROM SIGNING_KEY WHERE tenant_identity = ?";
            try {
                existingKeyEntity = (KeyEntity)this.jdbcTemplate.queryForObject("SELECT * FROM SIGNING_KEY WHERE tenant_identity = ?", (RowMapper)new KeyEntityRowMapper(), new Object[]{tenantIdentity});
            }
            catch (EmptyResultDataAccessException e) {
                existingKeyEntity = null;
            }
            if (existingKeyEntity == null) {
                logger.debug("No key found with identity='" + tenantIdentity + "'. Creating new key.");
                KeyEntity newKeyEntity = new KeyEntity();
                newKeyEntity.setId(UUID.randomUUID().toString());
                newKeyEntity.setTenantIdentity(tenantIdentity);
                newKeyEntity.setKeyValue(UUID.randomUUID().toString());
                String insertSql = "INSERT INTO SIGNING_KEY (ID, TENANT_IDENTITY, KEY_VALUE) VALUES (?, ?, ?)";
                this.jdbcTemplate.update("INSERT INTO SIGNING_KEY (ID, TENANT_IDENTITY, KEY_VALUE) VALUES (?, ?, ?)", new Object[]{newKeyEntity.getId(), newKeyEntity.getTenantIdentity(), newKeyEntity.getKeyValue()});
                key = KeyMappings.map(newKeyEntity);
            } else {
                key = KeyMappings.map(existingKeyEntity);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return key;
    }

    @Override
    public void deleteKey(String tenantIdentity) {
        if (tenantIdentity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        this.writeLock.lock();
        try {
            logger.debug("Deleting key with identity='" + tenantIdentity + "'.");
            String deleteSql = "DELETE FROM SIGNING_KEY WHERE tenant_identity = ?";
            this.jdbcTemplate.update("DELETE FROM SIGNING_KEY WHERE tenant_identity = ?", new Object[]{tenantIdentity});
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

