/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.util;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.nifi.toolkit.tls.util.PasswordsExhaustedException;

public class PasswordUtil {
    private final SecureRandom secureRandom;

    public PasswordUtil() {
        this(new SecureRandom());
    }

    public PasswordUtil(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public String generatePassword() {
        byte[] bytes = new byte[32];
        this.secureRandom.nextBytes(bytes);
        String string = Base64.getEncoder().encodeToString(bytes);
        while (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Supplier<String> passwordSupplier() {
        return () -> this.generatePassword();
    }

    public static Supplier<String> passwordSupplier(String password) {
        return () -> password;
    }

    public static Supplier<String> passwordSupplier(String exhaustedMessage, String[] passwords) {
        AtomicInteger index = new AtomicInteger(0);
        return () -> {
            int i = index.getAndIncrement();
            if (i < passwords.length) {
                return passwords[i];
            }
            throw new PasswordsExhaustedException(exhaustedMessage);
        };
    }
}

