/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public abstract class AbstractIntHashSet
implements Mutable {
    protected static final int MIN_INITIAL_CAPACITY = 16;
    protected static final int noEntryKey = -1;
    protected final double loadFactor;
    protected final int noEntryKeyValue;
    protected int capacity;
    protected int free;
    protected int[] keys;
    protected int mask;

    public AbstractIntHashSet(int initialCapacity, double loadFactor) {
        this(initialCapacity, loadFactor, -1);
    }

    public AbstractIntHashSet(int initialCapacity, double loadFactor, int noKeyValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.noEntryKeyValue = noKeyValue;
        this.free = this.capacity = Math.max(initialCapacity, 16);
        this.loadFactor = loadFactor;
        int len = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.keys = new int[len];
        this.mask = len - 1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.free = this.capacity;
    }

    public boolean excludes(int key) {
        return this.keyIndex(key) > -1;
    }

    public int keyIndex(int key) {
        int index = key & this.mask;
        if (this.keys[index] == this.noEntryKeyValue) {
            return index;
        }
        if (key == this.keys[index]) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public int remove(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            int key = this.keys[from];
            while (key != this.noEntryKeyValue) {
                int to;
                int idealHit = key & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != this.noEntryKeyValue ? this.probe(key, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    private int probe(int key, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != this.noEntryKeyValue) continue;
            return index;
        } while (key != this.keys[index]);
        return -index - 1;
    }

    protected abstract void erase(int var1);

    protected abstract void move(int var1, int var2);
}

