/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ByteArrayCache {
    private final BlockingQueue<byte[]> queue;
    private final int bufferSize;

    public ByteArrayCache(int maxCapacity, int bufferSize) {
        this.queue = new LinkedBlockingQueue<byte[]>(maxCapacity);
        this.bufferSize = bufferSize;
    }

    public byte[] checkOut() {
        byte[] array = (byte[])this.queue.poll();
        if (array != null) {
            return array;
        }
        return new byte[this.bufferSize];
    }

    public void checkIn(byte[] array) {
        if (array.length != this.bufferSize) {
            return;
        }
        this.queue.offer(array);
    }
}

