/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWTClaimsSet;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.JwsSignerProvider;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class StandardBearerTokenProvider
implements BearerTokenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardBearerTokenProvider.class);
    private static final Duration MAXIMUM_EXPIRATION = Duration.ofHours(12L);
    private static final Duration MINIMUM_EXPIRATION = Duration.ofMinutes(1L);
    private final JwsSignerProvider jwsSignerProvider;
    private final IssuerProvider issuerProvider;

    public StandardBearerTokenProvider(JwsSignerProvider jwsSignerProvider, IssuerProvider issuerProvider) {
        this.jwsSignerProvider = jwsSignerProvider;
        this.issuerProvider = issuerProvider;
    }

    @Override
    public String getBearerToken(LoginAuthenticationToken loginAuthenticationToken) {
        Objects.requireNonNull(loginAuthenticationToken, "LoginAuthenticationToken required");
        String subject = Objects.requireNonNull(loginAuthenticationToken.getPrincipal(), "Principal required").toString();
        String username = loginAuthenticationToken.getName();
        List<String> groups = this.getGroups(loginAuthenticationToken.getAuthorities());
        URI issuerUri = this.issuerProvider.getIssuer();
        String issuer = issuerUri.toString();
        Date now = new Date();
        Date expirationTime = this.getExpirationTime(loginAuthenticationToken);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().jwtID(UUID.randomUUID().toString()).subject(subject).issuer(issuer).audience(issuer).notBeforeTime(now).issueTime(now).expirationTime(expirationTime).claim(SupportedClaim.PREFERRED_USERNAME.getClaim(), (Object)username).claim(SupportedClaim.GROUPS.getClaim(), groups).build();
        return this.getSignedBearerToken(claims);
    }

    private Date getExpirationTime(LoginAuthenticationToken loginAuthenticationToken) {
        Instant expiration = loginAuthenticationToken.getExpiration();
        Instant maximumExpiration = Instant.now().plus(MAXIMUM_EXPIRATION);
        Instant minimumExpiration = Instant.now().plus(MINIMUM_EXPIRATION);
        String identity = loginAuthenticationToken.getName();
        if (expiration.isAfter(maximumExpiration)) {
            LOGGER.warn("Identity [{}] Token Expiration [{}] greater than maximum [{}]", new Object[]{identity, expiration, MAXIMUM_EXPIRATION});
            expiration = maximumExpiration;
        } else if (expiration.isBefore(minimumExpiration)) {
            LOGGER.warn("Identity [{}] Token Expiration [{}] less than minimum [{}]", new Object[]{identity, expiration, MINIMUM_EXPIRATION});
            expiration = minimumExpiration;
        }
        return Date.from(expiration);
    }

    private String getSignedBearerToken(JWTClaimsSet claims) {
        Date expirationTime = claims.getExpirationTime();
        JwsSignerContainer jwsSignerContainer = this.jwsSignerProvider.getJwsSignerContainer(expirationTime.toInstant());
        String keyIdentifier = jwsSignerContainer.getKeyIdentifier();
        JWSAlgorithm algorithm = jwsSignerContainer.getJwsAlgorithm();
        JWSHeader header = new JWSHeader.Builder(algorithm).keyID(keyIdentifier).build();
        Payload payload = new Payload(claims.toJSONObject());
        JWSObject jwsObject = new JWSObject(header, payload);
        JWSSigner signer = jwsSignerContainer.getJwsSigner();
        try {
            jwsObject.sign(signer);
        }
        catch (JOSEException e) {
            String message = String.format("Signing Failed for Algorithm [%s] Key Identifier [%s]", algorithm, keyIdentifier);
            throw new IllegalArgumentException(message, e);
        }
        LOGGER.debug("Signed Bearer Token using Key [{}] for Subject [{}]", (Object)keyIdentifier, (Object)claims.getSubject());
        return jwsObject.serialize();
    }

    private List<String> getGroups(Collection<? extends GrantedAuthority> authorities) {
        return authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }
}

