/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKerberosUser
implements KerberosUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKerberosUser.class);
    static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final float TICKET_RENEW_WINDOW = 0.8f;
    static final String KERBEROS_USER_CONFIG_ENTRY = "KerberosUser";
    protected final String principal;
    protected final AtomicBoolean loggedIn = new AtomicBoolean(false);
    protected Subject subject;
    protected LoginContext loginContext;

    public AbstractKerberosUser(String principal) {
        this.principal = principal;
        Validate.notBlank((CharSequence)this.principal);
    }

    public synchronized void login() {
        if (this.isLoggedIn()) {
            return;
        }
        try {
            if (this.loginContext == null) {
                LOGGER.debug("Initializing new login context...");
                if (this.subject == null) {
                    this.subject = new Subject();
                }
                this.loginContext = new LoginContext(KERBEROS_USER_CONFIG_ENTRY, this.subject, this.createCallbackHandler(), this.createConfiguration());
            }
            this.loginContext.login();
            this.loggedIn.set(true);
            LOGGER.debug("Successful login for {}", (Object)this.principal);
        }
        catch (LoginException le) {
            throw new KerberosLoginException("Unable to login with " + this.principal + " due to: " + le.getMessage(), (Throwable)le);
        }
    }

    protected abstract Configuration createConfiguration();

    protected abstract CallbackHandler createCallbackHandler();

    public AppConfigurationEntry getConfigurationEntry() {
        Configuration configuration = this.createConfiguration();
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(KERBEROS_USER_CONFIG_ENTRY);
        if (configurationEntries == null || configurationEntries.length != 1) {
            throw new IllegalStateException("Configuration must return one entry");
        }
        return configurationEntries[0];
    }

    public synchronized void logout() {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            this.loginContext.logout();
            this.loggedIn.set(false);
            LOGGER.debug("Successful logout for {}", (Object)this.principal);
            this.loginContext = null;
        }
        catch (LoginException e) {
            throw new KerberosLoginException("Logout failed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T doAs(PrivilegedAction<T> action) throws IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IllegalStateException, PrivilegedActionException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    public synchronized boolean checkTGTAndRelogin() {
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            LOGGER.debug("TGT for {} was not found", (Object)this.principal);
            return this.logoutAndLogin();
        }
        if (tgt != null && System.currentTimeMillis() < this.getRefreshTime(tgt)) {
            LOGGER.debug("TGT for {} was found, but has not reached expiration window", (Object)this.principal);
            return false;
        }
        if (!tgt.isRenewable() || tgt.getRenewTill() == null) {
            return this.logoutAndLogin();
        }
        LOGGER.debug("TGT for {} is renewable, will attempt refresh", (Object)this.principal);
        try {
            tgt.refresh();
            LOGGER.debug("TGT for {} was refreshed", (Object)this.principal);
            return true;
        }
        catch (RefreshFailedException e) {
            LOGGER.debug("TGT for {} could not be refreshed", (Object)this.principal);
            LOGGER.trace("", (Throwable)e);
            return this.logoutAndLogin();
        }
    }

    private boolean logoutAndLogin() {
        LOGGER.debug("Performing logout/login", (Object)this.principal);
        this.logout();
        this.login();
        return true;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!this.isTGSPrincipal(ticket.getServer())) continue;
            return ticket;
        }
        return null;
    }

    private boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        if (principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm())) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Found TGS principal: " + principal.getName());
            }
            return true;
        }
        return false;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        if (LOGGER.isTraceEnabled()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            String startDate = dateFormat.format(new Date(start));
            String endDate = dateFormat.format(new Date(end));
            LOGGER.trace("TGT for {} is valid starting at [{}]", (Object)this.principal, (Object)startDate);
            LOGGER.trace("TGT for {} expires at [{}]", (Object)this.principal, (Object)endDate);
            if (tgt.getRenewTill() == null) {
                LOGGER.trace("TGT for {} is non-renewable", (Object)this.principal);
            } else {
                LOGGER.trace("TGT for {} renews until [{}]", (Object)this.principal, (Object)dateFormat.format(tgt.getRenewTill()));
            }
        }
        return start + (long)((float)(end - start) * 0.8f);
    }

    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    public String getPrincipal() {
        return this.principal;
    }

    Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "KerberosUser{principal='" + this.principal + '\'' + ", loggedIn=" + this.loggedIn + '}';
    }
}

