/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import com.nimbusds.jwt.JWTParser;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class JwtIssuerReactiveAuthenticationManagerResolver
implements ReactiveAuthenticationManagerResolver<ServerWebExchange> {
    private final ReactiveAuthenticationManager authenticationManager;

    public JwtIssuerReactiveAuthenticationManagerResolver(String ... trustedIssuers) {
        this(Arrays.asList(trustedIssuers));
    }

    public JwtIssuerReactiveAuthenticationManagerResolver(Collection<String> trustedIssuers) {
        Assert.notEmpty(trustedIssuers, (String)"trustedIssuers cannot be empty");
        this.authenticationManager = new ResolvingAuthenticationManager(new TrustedIssuerJwtAuthenticationManagerResolver(new ArrayList<String>(trustedIssuers)::contains));
    }

    public JwtIssuerReactiveAuthenticationManagerResolver(ReactiveAuthenticationManagerResolver<String> issuerAuthenticationManagerResolver) {
        Assert.notNull(issuerAuthenticationManagerResolver, (String)"issuerAuthenticationManagerResolver cannot be null");
        this.authenticationManager = new ResolvingAuthenticationManager(issuerAuthenticationManagerResolver);
    }

    public Mono<ReactiveAuthenticationManager> resolve(ServerWebExchange exchange) {
        return Mono.just((Object)this.authenticationManager);
    }

    static class TrustedIssuerJwtAuthenticationManagerResolver
    implements ReactiveAuthenticationManagerResolver<String> {
        private final Map<String, Mono<ReactiveAuthenticationManager>> authenticationManagers = new ConcurrentHashMap<String, Mono<ReactiveAuthenticationManager>>();
        private final Predicate<String> trustedIssuer;

        TrustedIssuerJwtAuthenticationManagerResolver(Predicate<String> trustedIssuer) {
            this.trustedIssuer = trustedIssuer;
        }

        public Mono<ReactiveAuthenticationManager> resolve(String issuer) {
            if (!this.trustedIssuer.test(issuer)) {
                return Mono.empty();
            }
            return this.authenticationManagers.computeIfAbsent(issuer, k -> Mono.fromCallable(() -> new JwtReactiveAuthenticationManager(ReactiveJwtDecoders.fromIssuerLocation((String)k))).subscribeOn(Schedulers.boundedElastic()).cache(manager -> Duration.ofMillis(Long.MAX_VALUE), ex -> Duration.ZERO, () -> Duration.ZERO));
        }
    }

    private static class JwtClaimIssuerConverter
    implements Converter<BearerTokenAuthenticationToken, Mono<String>> {
        private JwtClaimIssuerConverter() {
        }

        public Mono<String> convert(@NonNull BearerTokenAuthenticationToken token) {
            try {
                String issuer = JWTParser.parse((String)token.getToken()).getJWTClaimsSet().getIssuer();
                if (issuer == null) {
                    throw new InvalidBearerTokenException("Missing issuer");
                }
                return Mono.just((Object)issuer);
            }
            catch (Exception ex) {
                return Mono.error(() -> new InvalidBearerTokenException(ex.getMessage(), ex));
            }
        }
    }

    private static class ResolvingAuthenticationManager
    implements ReactiveAuthenticationManager {
        private final Converter<BearerTokenAuthenticationToken, Mono<String>> issuerConverter = new JwtClaimIssuerConverter();
        private final ReactiveAuthenticationManagerResolver<String> issuerAuthenticationManagerResolver;

        ResolvingAuthenticationManager(ReactiveAuthenticationManagerResolver<String> issuerAuthenticationManagerResolver) {
            this.issuerAuthenticationManagerResolver = issuerAuthenticationManagerResolver;
        }

        public Mono<Authentication> authenticate(Authentication authentication) {
            Assert.isTrue((boolean)(authentication instanceof BearerTokenAuthenticationToken), (String)"Authentication must be of type BearerTokenAuthenticationToken");
            BearerTokenAuthenticationToken token = (BearerTokenAuthenticationToken)authentication;
            return ((Mono)this.issuerConverter.convert((Object)token)).flatMap(issuer -> this.issuerAuthenticationManagerResolver.resolve(issuer).switchIfEmpty(Mono.error(() -> new InvalidBearerTokenException("Invalid issuer " + issuer)))).flatMap(manager -> manager.authenticate(authentication));
        }
    }
}

