/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.validation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.parameter.ParameterLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidationContext
implements ValidationContext {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValidationContext.class);
    private final ParameterLookup parameterLookup;
    private final Map<PropertyDescriptor, PropertyConfiguration> properties;

    public AbstractValidationContext(ParameterLookup parameterLookup, Map<PropertyDescriptor, PropertyConfiguration> properties) {
        this.parameterLookup = parameterLookup;
        this.properties = properties;
    }

    public boolean isDependencySatisfied(PropertyDescriptor propertyDescriptor, Function<String, PropertyDescriptor> propertyDescriptorLookup) {
        return this.isDependencySatisfied(propertyDescriptor, propertyDescriptorLookup, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDependencySatisfied(PropertyDescriptor propertyDescriptor, Function<String, PropertyDescriptor> propertyDescriptorLookup, Set<String> propertiesSeen) {
        Set dependencies = propertyDescriptor.getDependencies();
        if (dependencies.isEmpty()) {
            logger.debug("Dependency for {} is satisfied because it has no dependencies", (Object)propertyDescriptor);
            return true;
        }
        boolean added = propertiesSeen.add(propertyDescriptor.getName());
        if (!added) {
            logger.debug("Dependency for {} is not satisifed because its dependency chain contains a loop: {}", (Object)propertyDescriptor, propertiesSeen);
            return false;
        }
        try {
            for (PropertyDependency dependency : dependencies) {
                String dependencyValue;
                String dependencyName = dependency.getPropertyName();
                PropertyDescriptor dependencyDescriptor = propertyDescriptorLookup.apply(dependencyName);
                if (dependencyDescriptor == null) {
                    logger.debug("Dependency for {} is not satisfied because it has a dependency on {}, which has no property descriptor", (Object)propertyDescriptor, (Object)dependencyName);
                    boolean bl = false;
                    return bl;
                }
                PropertyValue propertyValue = this.getProperty(dependencyDescriptor);
                String string = dependencyValue = propertyValue == null ? dependencyDescriptor.getDefaultValue() : propertyValue.getValue();
                if (dependencyValue == null) {
                    logger.debug("Dependency for {} is not satisfied because it has a dependency on {}, which has a null value", (Object)propertyDescriptor, (Object)dependencyName);
                    boolean bl = false;
                    return bl;
                }
                boolean transitiveDependencySatisfied = this.isDependencySatisfied(dependencyDescriptor, propertyDescriptorLookup, propertiesSeen);
                if (!transitiveDependencySatisfied) {
                    logger.debug("Dependency for {} is not satisfied because it has a dependency on {} and {} does not have its dependencies satisfied", new Object[]{propertyDescriptor, dependencyName, dependencyName});
                    boolean bl = false;
                    return bl;
                }
                Set dependentValues = dependency.getDependentValues();
                if (dependentValues == null || dependentValues.contains(dependencyValue)) continue;
                logger.debug("Dependency for {} is not satisfied because it depends on {}, which has a value of {}. Dependent values = {}", new Object[]{propertyDescriptor, dependencyName, dependencyValue, dependentValues});
                boolean bl = false;
                return bl;
            }
            logger.debug("All dependencies for {} are satisfied", (Object)propertyDescriptor);
            boolean bl = true;
            return bl;
        }
        finally {
            propertiesSeen.remove(propertyDescriptor.getName());
        }
    }
}

