/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.nifi.controller.GarbageCollectionEvent;
import org.apache.nifi.util.FormatUtils;

public class StandardGarbageCollectionEvent
implements GarbageCollectionEvent {
    private final String gcName;
    private final String action;
    private final String cause;
    private final long startTime;
    private final long endTime;
    private final List<GarbageCollectionEvent.GarbageCollectionHeapSize> heapSizes;
    private final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");

    public StandardGarbageCollectionEvent(String gcName, String action, String cause, long startTime, long endTime, List<GarbageCollectionEvent.GarbageCollectionHeapSize> heapSizes) {
        this.gcName = gcName;
        this.action = action;
        this.cause = cause;
        this.startTime = startTime;
        this.endTime = endTime;
        this.heapSizes = heapSizes;
    }

    @Override
    public String getGarbageCollectorName() {
        return this.gcName;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getCause() {
        return this.cause;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getDuration() {
        return this.endTime - this.startTime;
    }

    @Override
    public List<GarbageCollectionEvent.GarbageCollectionHeapSize> getHeapSizes() {
        return Collections.unmodifiableList(this.heapSizes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GarbageCollectionEvent[collectorName=").append(this.gcName).append(", action=").append(this.action).append(", cause=").append(this.cause).append(", startTime=").append(this.dateFormat.format(new Date(this.startTime))).append(", endTime=").append(this.dateFormat.format(new Date(this.endTime))).append(", duration=").append(NumberFormat.getInstance().format(this.endTime - this.startTime)).append(" ms, heap sizes={");
        for (int i = 0; i < this.heapSizes.size(); ++i) {
            GarbageCollectionEvent.GarbageCollectionHeapSize size = this.heapSizes.get(i);
            sb.append(size.getMemoryPoolName()).append(": ").append(FormatUtils.formatDataSize((double)size.getUsedBeforeCollection())).append(" => ").append(FormatUtils.formatDataSize((double)size.getUsedAfterCollection()));
            if (i >= this.heapSizes.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}]");
        return sb.toString();
    }

    public static class StandardGarbageCollectionHeapSize
    implements GarbageCollectionEvent.GarbageCollectionHeapSize {
        private final String memoryPoolName;
        private final long usedBefore;
        private final long usedAfter;

        public StandardGarbageCollectionHeapSize(String memoryPoolName, long usedBefore, long usedAfter) {
            this.memoryPoolName = memoryPoolName;
            this.usedBefore = usedBefore;
            this.usedAfter = usedAfter;
        }

        @Override
        public String getMemoryPoolName() {
            return this.memoryPoolName;
        }

        @Override
        public long getUsedBeforeCollection() {
            return this.usedBefore;
        }

        @Override
        public long getUsedAfterCollection() {
            return this.usedAfter;
        }

        public String toString() {
            return "HeapSize[memoryPool=" + this.memoryPoolName + ", " + FormatUtils.formatDataSize((double)this.usedBefore) + " => " + FormatUtils.formatDataSize((double)this.usedAfter) + "]";
        }
    }
}

