/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.ExtensionRepoGroupsResult;

public class ListBundleGroups
extends AbstractNiFiRegistryCommand<ExtensionRepoGroupsResult> {
    public ListBundleGroups() {
        super("list-bundle-groups", ExtensionRepoGroupsResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
    }

    @Override
    public String getDescription() {
        return "Lists the bundle groups in the bucket with the given name. If a bucket name contains spaces, the argument must be wrapped in quotes.";
    }

    @Override
    public ExtensionRepoGroupsResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        ExtensionRepoClient extensionRepoClient = client.getExtensionRepoClient();
        List groups = extensionRepoClient.getGroups(bucketName);
        return new ExtensionRepoGroupsResult(this.getResultType(properties), groups);
    }
}

