/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.bootstrap.command.BootstrapCommand;
import org.apache.nifi.bootstrap.command.CommandStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StartBootstrapCommand
implements BootstrapCommand {
    private static final long MONITOR_INTERVAL = 5L;
    private static final Logger logger = LoggerFactory.getLogger(StartBootstrapCommand.class);
    private final BootstrapCommand runCommand;
    private final BootstrapCommand statusCommand;
    private final Duration startWatchDelay;
    private final ScheduledExecutorService scheduledExecutorService;
    private CommandStatus commandStatus = CommandStatus.ERROR;

    StartBootstrapCommand(BootstrapCommand runCommand, BootstrapCommand statusCommand, Duration startWatchDelay) {
        this.runCommand = Objects.requireNonNull(runCommand);
        this.statusCommand = Objects.requireNonNull(statusCommand);
        this.startWatchDelay = Objects.requireNonNull(startWatchDelay);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, command -> {
            Thread thread = new Thread(command);
            thread.setName(StartBootstrapCommand.class.getSimpleName());
            return thread;
        });
    }

    @Override
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    @Override
    public void run() {
        this.runCommand.run();
        this.commandStatus = this.runCommand.getCommandStatus();
        if (CommandStatus.SUCCESS == this.commandStatus) {
            StartWatchCommand startWatchCommand = new StartWatchCommand();
            this.scheduledExecutorService.schedule(startWatchCommand, this.startWatchDelay.toMillis(), TimeUnit.MILLISECONDS);
            this.commandStatus = CommandStatus.RUNNING;
        } else {
            this.scheduledExecutorService.shutdown();
        }
    }

    private class StartWatchCommand
    implements Runnable {
        private StartWatchCommand() {
        }

        @Override
        public void run() {
            StartBootstrapCommand.this.statusCommand.run();
            CommandStatus status = StartBootstrapCommand.this.statusCommand.getCommandStatus();
            if (CommandStatus.SUCCESS == status) {
                WatchCommand watchCommand = new WatchCommand();
                StartBootstrapCommand.this.scheduledExecutorService.scheduleAtFixedRate(watchCommand, 5L, 5L, TimeUnit.SECONDS);
                logger.info("Application monitoring started");
            } else {
                logger.warn("Application monitoring failed with status [{}]", (Object)status);
                StartBootstrapCommand.this.scheduledExecutorService.shutdown();
                StartBootstrapCommand.this.commandStatus = status;
            }
        }
    }

    private class WatchCommand
    implements Runnable {
        private WatchCommand() {
        }

        @Override
        public void run() {
            StartBootstrapCommand.this.statusCommand.run();
            CommandStatus status = StartBootstrapCommand.this.statusCommand.getCommandStatus();
            if (CommandStatus.SUCCESS == status) {
                logger.debug("Application running");
            } else {
                logger.warn("Application not running [{}]", (Object)status);
                StartBootstrapCommand.this.runCommand.run();
            }
        }
    }
}

