/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateOutput;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.ValidateOutput;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.extensibility.AppliedMigration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.license.VersionPrinter;

public class CommandResultFactory {
    public static InfoResult createInfoResult(Configuration configuration, Database database, MigrationInfo[] migrationInfos, MigrationInfo current, boolean allSchemasEmpty) {
        String databaseName = CommandResultFactory.getDatabaseName(configuration, database);
        return CommandResultFactory.createInfoResult(configuration, databaseName, migrationInfos, current, allSchemasEmpty);
    }

    public static InfoResult createInfoResult(Configuration configuration, String databaseName, MigrationInfo[] migrationInfos, MigrationInfo current, boolean allSchemasEmpty) {
        String flywayVersion = VersionPrinter.getVersion();
        Set<MigrationInfo> undoableMigrations = CommandResultFactory.getUndoMigrations(migrationInfos);
        migrationInfos = CommandResultFactory.removeAvailableUndoMigrations(migrationInfos);
        ArrayList<InfoOutput> infoOutputs = new ArrayList<InfoOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            infoOutputs.add(CommandResultFactory.createInfoOutput(undoableMigrations, migrationInfo));
        }
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
        String schemaVersion = schemaVersionToOutput.getVersion();
        return new InfoResult(flywayVersion, databaseName, schemaVersion, String.join((CharSequence)", ", configuration.getSchemas()), infoOutputs, allSchemasEmpty);
    }

    public static MigrateResult createMigrateResult(String databaseName, String databaseType, Configuration configuration) {
        String flywayVersion = VersionPrinter.getVersion();
        return new MigrateResult(flywayVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()), databaseType);
    }

    public static CleanResult createCleanResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new CleanResult(flywayVersion, databaseName);
    }

    public static BaselineResult createBaselineResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new BaselineResult(flywayVersion, databaseName);
    }

    public static ValidateResult createValidateResult(String databaseName, ErrorDetails validationError, int validationCount, List<ValidateOutput> invalidMigrations, List<String> warnings) {
        String flywayVersion = VersionPrinter.getVersion();
        boolean validationSuccessful = validationError == null;
        ArrayList<ValidateOutput> invalidMigrationsList = invalidMigrations == null ? new ArrayList<ValidateOutput>() : invalidMigrations;
        return new ValidateResult(flywayVersion, databaseName, validationError, validationSuccessful, validationCount, invalidMigrationsList, warnings);
    }

    public static RepairResult createRepairResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new RepairResult(flywayVersion, databaseName);
    }

    public static InfoOutput createInfoOutput(Set<MigrationInfo> undoableMigrations, MigrationInfo migrationInfo) {
        return new InfoOutput(CommandResultFactory.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getVersion() != null ? migrationInfo.getVersion().getRawVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toInstant().toString() : "", migrationInfo.getState().getDisplayName(), CommandResultFactory.getUndoableStatus(migrationInfo, undoableMigrations), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", CommandResultFactory.getUndoablePath(migrationInfo, undoableMigrations), migrationInfo.getInstalledBy() != null ? migrationInfo.getInstalledBy() : "", migrationInfo.getShouldExecuteExpression(), migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    public static MigrateOutput createMigrateOutput(MigrationInfo migrationInfo, int executionTime) {
        return CommandResultFactory.createMigrateOutput(migrationInfo, executionTime, false);
    }

    public static MigrateOutput createMigrateOutput(MigrationInfo migrationInfo, int executionTime, Boolean rolledBack) {
        return new MigrateOutput(CommandResultFactory.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", executionTime, rolledBack);
    }

    public static ValidateOutput createValidateOutput(MigrationInfo migrationInfo, ErrorDetails validateError) {
        return new ValidateOutput(migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", validateError);
    }

    public static RepairOutput createRepairOutput(MigrationInfo migrationInfo) {
        return new RepairOutput(migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "");
    }

    public static RepairOutput createRepairOutput(AppliedMigration am) {
        return new RepairOutput(am.getVersion() != null ? am.getVersion().getVersion() : "", am.getDescription(), "");
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationInfo> undoableMigrations) {
        if (migrationInfo.getVersion() != null && !migrationInfo.getType().isUndo() && !migrationInfo.getState().equals((Object)MigrationState.UNDONE)) {
            if (!migrationInfo.getState().isFailed() && undoableMigrations.stream().anyMatch(u -> u.getVersion().equals(migrationInfo.getVersion()))) {
                return "Yes";
            }
            return "No";
        }
        return "";
    }

    private static String getUndoablePath(MigrationInfo migrationInfo, Set<MigrationInfo> undoableMigrations) {
        if (!(migrationInfo.getVersion() == null || migrationInfo.getType().isUndo() || migrationInfo.getState().equals((Object)MigrationState.UNDONE) || migrationInfo.getState().isFailed())) {
            return undoableMigrations.stream().filter(u -> u.getVersion().equals(migrationInfo.getVersion())).findFirst().map(MigrationInfo::getPhysicalLocation).orElse("");
        }
        return "";
    }

    private static Set<MigrationInfo> getUndoMigrations(MigrationInfo[] migrationInfos) {
        return Arrays.stream(migrationInfos).filter(m -> m.getType().isUndo()).collect(Collectors.toSet());
    }

    private static MigrationInfo[] removeAvailableUndoMigrations(MigrationInfo[] migrationInfos) {
        return (MigrationInfo[])Arrays.stream(migrationInfos).filter(m -> !m.getState().equals((Object)MigrationState.AVAILABLE)).toArray(MigrationInfo[]::new);
    }

    private static String getDatabaseName(Configuration configuration, Database database) {
        try {
            return database.getCatalog();
        }
        catch (Exception e) {
            String string;
            block10: {
                Connection connection = configuration.getDataSource().getConnection();
                try {
                    String catalog = connection.getCatalog();
                    String string2 = string = catalog != null ? catalog : "";
                    if (connection == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e1) {
                        return "";
                    }
                }
                connection.close();
            }
            return string;
        }
    }

    private static String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        if (migrationInfo.getType().isUndo()) {
            return "Undo";
        }
        if (migrationInfo.getType().isBaseline()) {
            return "Baseline";
        }
        return "Versioned";
    }
}

