/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.aggregation;

import java.util.List;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class SumExpression<T>
extends AbstractAggregationExpression<T, Number> {
    private final FunctionParameterTypePredicate<Object> _typeValidator = FunctionParameterTypePredicate.builder().allowNumbers().build();

    public SumExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public CollectorType getCollectorType() {
        return CollectorType.SUMMING;
    }

    @Override
    public Number aggregate(List<T> items) {
        List<?> args = this.getArguments(items, this._typeValidator);
        return NumberConverter.narrow(args.stream().mapToLong(NumberConverter::toLong).sum());
    }
}

