/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.watcher;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.utils.FilenameNormalization;

public class WatchThread
extends Thread {
    private String name;
    private IWatchWriter writer;
    private Configuration config;
    private RoyaleProject project;
    private Workspace workspace;
    private ProblemQuery problems;
    private Map<WatchKey, Path> watchKeys;
    private WatchService watchService;

    public WatchThread(String name, IWatchWriter writer, Configuration config, RoyaleProject project, Workspace workspace, ProblemQuery problems) {
        this.name = name;
        this.writer = writer;
        this.config = config;
        this.project = project;
        this.workspace = workspace;
        this.problems = problems;
    }

    @Override
    public void run() {
        try {
            this.watchKeys = new HashMap<WatchKey, Path>();
            this.watchService = FileSystems.getDefault().newWatchService();
            HashSet<Path> watchedPaths = new HashSet<Path>();
            for (String sourcePath : this.config.getCompilerSourcePath()) {
                sourcePath = FilenameNormalization.normalize(sourcePath);
                this.watchPath(Paths.get(sourcePath, new String[0]), watchedPaths);
            }
            for (String fileSpec : this.config.getFileSpecs()) {
                fileSpec = FilenameNormalization.normalize(fileSpec);
                Path fileSpecPath = Paths.get(fileSpec, new String[0]);
                this.watchPath(fileSpecPath.getParent(), watchedPaths);
            }
            System.out.println("Watching for file changes in target " + this.name + "...");
            while (true) {
                if (this.isInterrupted()) {
                    return;
                }
                this.checkForChanges();
            }
        }
        catch (Exception e) {
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            System.err.println(problem);
            System.exit(ExitCode.FAILED_WITH_EXCEPTIONS.code);
            return;
        }
    }

    private void checkForChanges() throws Exception {
        WatchKey watchKey = this.watchService.take();
        HashSet<ICompilationUnit> changedCUs = new HashSet<ICompilationUnit>();
        while (watchKey != null) {
            this.processWatchKey(watchKey, changedCUs);
            watchKey = this.watchService.poll();
        }
        this.recompile(changedCUs);
    }

    private void processWatchKey(WatchKey watchKey, Set<ICompilationUnit> changedCUs) throws InterruptedException {
        Path path = this.watchKeys.get(watchKey);
        for (WatchEvent<?> event : watchKey.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            Path childPath = (Path)event.context();
            String fileName = (childPath = path.resolve(childPath)).getFileName().toString();
            if (!fileName.endsWith(".mxml") && !fileName.endsWith(".as")) continue;
            String normalizedChildPath = FilenameNormalization.normalize(childPath.toString());
            IFileSpecification fileSpec = this.workspace.getFileSpecification(normalizedChildPath);
            if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
                this.workspace.fileAdded(fileSpec);
            } else if (kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                this.workspace.fileRemoved(fileSpec);
            } else if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                this.workspace.fileChanged(fileSpec);
            }
            for (ICompilationUnit cu : this.workspace.getCompilationUnits(normalizedChildPath, this.project)) {
                changedCUs.add(cu);
            }
        }
        if (!watchKey.reset()) {
            this.watchKeys.remove(watchKey);
        }
    }

    private void recompile(Set<ICompilationUnit> changedCUs) throws InterruptedException, IOException {
        if (changedCUs.size() == 0) {
            return;
        }
        System.out.println("File change detected. Recompiling " + this.name + "...");
        this.problems.clear();
        this.writer.rebuild(changedCUs, this.problems.getProblems());
        for (ICompilationUnit cu : changedCUs) {
            DependencyTypeSet dependencyTypes = DependencyTypeSet.allOf();
            Set<ICompilationUnit> reverseDeps = this.project.getDirectReverseDependencies(cu, dependencyTypes);
            changedCUs.addAll(reverseDeps);
        }
        ArrayList<ICompilerProblem> errs = new ArrayList<ICompilerProblem>();
        ArrayList<ICompilerProblem> warns = new ArrayList<ICompilerProblem>();
        this.problems.getErrorsAndWarnings(errs, warns);
        if (!this.problems.hasFilteredProblems() || !this.problems.hasErrors()) {
            this.writer.write(changedCUs);
        }
        if (this.problems.hasFilteredProblems()) {
            Iterable<ICompilerProblem> filteredProblems = this.problems.getFilteredProblems();
            WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace);
            ProblemPrinter printer = new ProblemPrinter(formatter);
            printer.printProblems(filteredProblems);
        }
        System.out.println("Watching for file changes in target " + this.name + "...");
    }

    private void watchPath(Path path, Set<Path> watchedPaths) throws IOException {
        if (watchedPaths.contains(path = path.toAbsolutePath())) {
            return;
        }
        watchedPaths.add(path);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path subPath, BasicFileAttributes attrs) throws IOException {
                WatchKey watchKey = subPath.register(WatchThread.this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                WatchThread.this.watchKeys.put(watchKey, subPath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static interface IWatchWriter {
        public void rebuild(Collection<ICompilationUnit> var1, Collection<ICompilerProblem> var2) throws InterruptedException, IOException;

        public void write(Collection<ICompilationUnit> var1) throws InterruptedException, IOException;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

