/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.exceptions.BuildCanceledException;
import org.apache.royale.compiler.internal.graph.LinkReportWriter;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.LibraryPathManager;
import org.apache.royale.compiler.internal.resourcebundles.ResourceBundleUtils;
import org.apache.royale.compiler.internal.targets.LinkageChecker;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnableToCreateLinkReportProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetProgressMonitor;
import org.apache.royale.compiler.targets.ITargetReport;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.ISWCManager;
import org.apache.royale.swc.ISWCScript;
import org.apache.royale.utils.FileID;

public abstract class Target
implements ITarget {
    protected final CompilerProject project;
    protected final ITargetProgressMonitor progressMonitor;
    protected final ITargetSettings targetSettings;
    private LinkageChecker linkageChecker;
    private Set<String> metadataNames;
    private BuiltCompilationUnitSet builtCompilationUnits;
    private Iterable<ICompilerProblem> fatalProblems;
    private ITargetReport targetReport;
    private int percentCompleted = 0;

    public static ImmutableList<IDefinition> getAllExternallyVisibleDefinitions(Collection<ICompilationUnit> compilationUnits) throws InterruptedException {
        assert (compilationUnits != null) : "Expected collection of compilation units.";
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
            builder.addAll(result.getExternallyVisibleDefinitions());
        }
        return builder.build();
    }

    protected Target(CompilerProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        this.project = project;
        this.progressMonitor = progressMonitor;
        this.targetSettings = targetSettings;
        if (targetSettings.getASMetadataNames() != null) {
            this.addASMetadataNames(targetSettings.getASMetadataNames());
        }
    }

    protected Set<ICompilationUnit> findAllCompilationUnitsToLink(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (compilationUnits != null) : "compilation units can't be null";
        assert (problems != null) : "problems can't be null";
        HashSet<ICompilationUnit> allCompilationUnitsInTarget = new HashSet<ICompilationUnit>(compilationUnits);
        Set<ICompilationUnit> dependencies = this.getDependentCompilationUnits(allCompilationUnitsInTarget, problems);
        allCompilationUnitsInTarget.addAll(dependencies);
        return allCompilationUnitsInTarget;
    }

    protected void waitForCompilationUnitToFinish(ICompilationUnit cu, Collection<ICompilerProblem> problems) throws InterruptedException {
        cu.waitForBuildFinish(problems, this.getTargetType());
    }

    private void buildCompilationUnits(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (compilationUnits != null) : "Expected compilation units.";
        assert (problems != null) : "Expected problem collection.";
        this.project.collectProblems(problems);
        for (ICompilationUnit cu : compilationUnits) {
            if (this.isCanceled()) {
                throw new BuildCanceledException();
            }
            cu.startBuildAsync(this.getTargetType());
        }
        int numCompilationUnit = compilationUnits.size();
        int totalCompUnitWorkCompleted = compilationUnits.size();
        for (ICompilationUnit cu : compilationUnits) {
            this.waitForCompilationUnitToFinish(cu, problems);
            if (this.updateProgress(numCompilationUnit, totalCompUnitWorkCompleted++, 95)) continue;
            return;
        }
    }

    @Override
    public ITargetSettings getTargetSettings() {
        return this.targetSettings;
    }

    protected abstract ITargetReport computeTargetReport() throws InterruptedException;

    @Override
    public final ITargetReport getTargetReport() throws InterruptedException {
        if (this.targetReport == null) {
            this.project.getWorkspace().startBuilding();
            try {
                this.targetReport = this.computeTargetReport();
            }
            finally {
                this.project.getWorkspace().doneBuilding();
            }
        }
        return this.targetReport;
    }

    protected BuiltCompilationUnitSet buildAllCompilationUnits() throws InterruptedException {
        Iterable<ICompilerProblem> fatalProblems = this.getFatalProblems();
        if (!Iterables.isEmpty(fatalProblems)) {
            return new BuiltCompilationUnitSet((ImmutableSet<ICompilationUnit>)ImmutableSet.of(), Collections.emptyList());
        }
        HashSet<ICompilationUnit> compilationUnits = new HashSet<ICompilationUnit>();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
        compilationUnits.addAll(rootedCompilationUnits.getUnits());
        compilationUnits.addAll(this.findAllCompilationUnitsToLink(compilationUnits, problems));
        this.buildCompilationUnits(compilationUnits, problems);
        return new BuiltCompilationUnitSet((ImmutableSet<ICompilationUnit>)ImmutableSet.copyOf(compilationUnits), problems);
    }

    protected BuiltCompilationUnitSet getBuiltCompilationUnitSet() throws InterruptedException {
        if (this.builtCompilationUnits == null) {
            this.builtCompilationUnits = this.buildAllCompilationUnits();
        }
        return this.builtCompilationUnits;
    }

    protected final Set<ICompilationUnit> getDependentCompilationUnits(Collection<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        HashSet<ICompilationUnit> workSet = new HashSet<ICompilationUnit>();
        HashSet<ICompilationUnit> visitedSet = new HashSet<ICompilationUnit>();
        int numCompUnitRemoved = 0;
        workSet.addAll(compilationUnits);
        while (workSet.size() > 0) {
            ICompilationUnit currentUnit = (ICompilationUnit)workSet.iterator().next();
            workSet.remove(currentUnit);
            if (!visitedSet.add(currentUnit)) continue;
            ++numCompUnitRemoved;
            currentUnit.startBuildAsync(this.getTargetType());
            DirectDependencies currentUnitDependencies = this.getDirectDependencies(currentUnit);
            Iterable<ICompilationUnit> newCompilationUnitWork = currentUnitDependencies.dependencies;
            Iterables.addAll(problems, currentUnitDependencies.problems);
            for (ICompilationUnit cu : newCompilationUnitWork) {
                workSet.add(cu);
                cu.startBuildAsync(this.getTargetType());
            }
            if (this.updateProgress(workSet.size() + numCompUnitRemoved, visitedSet.size(), 50)) continue;
            return Collections.emptySet();
        }
        TreeSet<ICompilationUnit> sortedSet = new TreeSet<ICompilationUnit>(new Comparator<ICompilationUnit>(){

            @Override
            public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        sortedSet.addAll(visitedSet);
        return sortedSet;
    }

    protected DirectDependencies getDirectDependencies(ICompilationUnit cu) throws InterruptedException {
        Set<ICompilationUnit> dependencies = this.project.getDependencies(cu);
        return new DirectDependencies(dependencies, Collections.emptyList());
    }

    public ImmutableList<ICompilationUnit> getReachableCompilationUnits(Collection<ICompilerProblem> problems) throws InterruptedException {
        RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
        Set<ICompilationUnit> root = rootedCompilationUnits.getUnits();
        Iterables.addAll(problems, rootedCompilationUnits.getProblems());
        List<ICompilationUnit> reachableCompilationUnitsInSWFOrder = this.project.getReachableCompilationUnitsInSWFOrder(root);
        ImmutableList compilationUnits = ImmutableList.copyOf(reachableCompilationUnitsInSWFOrder);
        return compilationUnits;
    }

    protected void createLinkReport(Collection<ICompilerProblem> problems) throws InterruptedException {
        if (this.targetSettings.getLinkReport() != null) {
            try {
                FileOutputStream outStream = new FileOutputStream(this.targetSettings.getLinkReport());
                ArrayList<ICompilerProblem> reachableProblems = new ArrayList<ICompilerProblem>();
                LinkReportWriter reportWriter = new LinkReportWriter(this.project.getDependencyGraph(), (List<ICompilationUnit>)this.getReachableCompilationUnits(reachableProblems), this.getLinkageChecker());
                reportWriter.writeToStream(outStream, problems);
            }
            catch (FileNotFoundException e) {
                UnableToCreateLinkReportProblem problem = new UnableToCreateLinkReportProblem(this.targetSettings.getLinkReport().getAbsolutePath());
                problems.add(problem);
            }
        }
    }

    protected abstract RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException;

    public abstract RootedCompilationUnits getRootedCompilationUnits() throws InterruptedException;

    @Override
    public final Set<ICompilationUnit> getIncludesCompilationUnits() throws InterruptedException {
        Workspace workspace = this.project.getWorkspace();
        HashSet<IResolvedQualifiersReference> includesReferences = new HashSet<IResolvedQualifiersReference>();
        for (String className : this.targetSettings.getIncludes()) {
            IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(workspace, className);
            includesReferences.add(ref);
        }
        return this.project.getScope().getCompilationUnitsForReferences(includesReferences);
    }

    public final Collection<ICompilationUnit> getIncludedResourceBundlesCompilationUnits(Collection<ICompilerProblem> problems) throws InterruptedException {
        HashSet<ICompilationUnit> includedResourceBundleCompUnits = new HashSet<ICompilationUnit>();
        for (String bundleName : this.targetSettings.getIncludeResourceBundles()) {
            includedResourceBundleCompUnits.addAll(ResourceBundleUtils.findCompilationUnits(bundleName, this.project, problems));
        }
        return includedResourceBundleCompUnits;
    }

    @Override
    public final Set<String> getASMetadataNames() {
        return this.metadataNames;
    }

    public void addASMetadataNames(Collection<String> metadataNames) {
        assert (metadataNames != null);
        if (this.metadataNames == null) {
            this.metadataNames = new HashSet<String>();
        }
        this.metadataNames.addAll(metadataNames);
    }

    protected final void buildStarted() {
        if (this.progressMonitor != null) {
            this.percentCompleted = 0;
        }
        this.project.getWorkspace().startBuilding();
    }

    protected boolean updateProgress(int numTotalCompilationUnits, int totalCompilationUnitsWorkCompleted, int maxPercentage) {
        if (this.progressMonitor != null) {
            int percentage = 50 * totalCompilationUnitsWorkCompleted / numTotalCompilationUnits;
            if (percentage > maxPercentage) {
                percentage = maxPercentage;
            }
            if (this.percentCompleted < percentage) {
                this.percentCompleted = percentage;
                this.progressMonitor.percentCompleted(this, this.percentCompleted);
            }
            return !this.isCanceled();
        }
        return true;
    }

    protected boolean updateProgress(int percentageCompleted) {
        if (this.progressMonitor != null) {
            if (this.percentCompleted < percentageCompleted) {
                this.percentCompleted = percentageCompleted;
                this.progressMonitor.percentCompleted(this, percentageCompleted);
            }
            return !this.isCanceled();
        }
        return true;
    }

    protected boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled(this);
        }
        return false;
    }

    protected final void buildFinished() {
        if (this.progressMonitor != null) {
            this.percentCompleted = 100;
            this.progressMonitor.done(this);
        }
        this.project.getWorkspace().doneBuilding();
    }

    protected boolean isLinkageExternal(ICompilationUnit cu, ITargetSettings targetSettings) throws InterruptedException {
        return this.getLinkageChecker().isExternal(cu);
    }

    protected final LinkageChecker getLinkageChecker() {
        if (this.linkageChecker == null) {
            this.linkageChecker = new LinkageChecker(this.project, this.targetSettings);
        }
        return this.linkageChecker;
    }

    protected void setLinkageChecker(LinkageChecker linkageChecker) {
        assert (this.linkageChecker == null);
        this.linkageChecker = linkageChecker;
        assert (this.linkageChecker != null);
    }

    protected Iterable<ICompilerProblem> getFatalProblems() throws InterruptedException {
        if (this.fatalProblems == null) {
            this.fatalProblems = this.computeFatalProblems();
        }
        return this.fatalProblems;
    }

    protected Iterable<ICompilerProblem> computeFatalProblems() throws InterruptedException {
        return ImmutableList.copyOf(this.project.getFatalProblems());
    }

    protected final Collection<ICompilationUnit> getIncludeLibrariesCompilationUnits() {
        HashSet<IResolvedQualifiersReference> includeLibrariesReferences = new HashSet<IResolvedQualifiersReference>();
        Set<FileID> swcs = LibraryPathManager.discoverSWCFilePaths(this.targetSettings.getIncludeLibraries().toArray(new File[0]));
        ISWCManager swcManager = this.project.getWorkspace().getSWCManager();
        Workspace w = this.project.getWorkspace();
        for (FileID swcPath : swcs) {
            File swcFile = swcPath.getFile();
            if (!swcFile.exists()) continue;
            ISWC swc = swcManager.get(swcFile);
            for (ISWCLibrary library : swc.getLibraries()) {
                for (ISWCScript script : library.getScripts()) {
                    for (String def : script.getDefinitions()) {
                        IResolvedQualifiersReference definitionRef = ReferenceFactory.packageQualifiedReference(w, def);
                        includeLibrariesReferences.add(definitionRef);
                    }
                }
            }
        }
        return this.project.getScope().getCompilationUnitsForReferences(includeLibrariesReferences);
    }

    public static class DirectDependencies {
        final Iterable<ICompilationUnit> dependencies;
        final Iterable<ICompilerProblem> problems;

        DirectDependencies(Iterable<ICompilationUnit> dependencies, Iterable<ICompilerProblem> problems) {
            this.dependencies = dependencies;
            this.problems = problems;
        }

        static DirectDependencies concat(DirectDependencies a, DirectDependencies b) {
            return new DirectDependencies(Iterables.concat(a.dependencies, b.dependencies), Iterables.concat(a.problems, b.problems));
        }
    }

    public static final class RootedCompilationUnits {
        private final SortedSet<ICompilationUnit> units;
        private final Iterable<ICompilerProblem> problems;

        static RootedCompilationUnits concat(RootedCompilationUnits base, Set<ICompilationUnit> units, Iterable<ICompilerProblem> problems) {
            return new RootedCompilationUnits((Set<ICompilationUnit>)Sets.union(base.units, units), Iterables.concat(base.problems, problems));
        }

        public RootedCompilationUnits(Set<ICompilationUnit> units, Iterable<ICompilerProblem> problems) {
            assert (units != null);
            assert (problems != null);
            this.units = new TreeSet<ICompilationUnit>(new Comparator<ICompilationUnit>(){

                @Override
                public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.units.addAll(units);
            this.problems = problems;
        }

        public Set<ICompilationUnit> getUnits() {
            return this.units;
        }

        public Iterable<ICompilerProblem> getProblems() {
            return this.problems;
        }
    }

    protected static final class BuiltCompilationUnitSet {
        public final ImmutableSet<ICompilationUnit> compilationUnits;
        final Iterable<ICompilerProblem> problems;

        BuiltCompilationUnitSet(ImmutableSet<ICompilationUnit> compilationUnits, Iterable<ICompilerProblem> problems) {
            this.compilationUnits = compilationUnits;
            this.problems = problems;
        }
    }
}

