/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.IOException;

public final class CheckMissingSemicolon
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType MISSING_SEMICOLON = DiagnosticType.disabled("JSC_MISSING_SEMICOLON", "Missing semicolon");
    private final AbstractCompiler compiler;

    public CheckMissingSemicolon(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isScript() && NodeUtil.isStatement(n) && this.shouldHaveSemicolon(n)) {
            this.checkSemicolon(t, n);
        }
    }

    private boolean shouldHaveSemicolon(Node statement) {
        if (statement.isFunction() || statement.isClass() || statement.isBlock() || statement.isLabelName() || statement.isModuleBody() || NodeUtil.isControlStructure(statement) && !statement.isDo()) {
            return false;
        }
        if (statement.isExport()) {
            return this.shouldHaveSemicolon(statement.getFirstChild());
        }
        return true;
    }

    private void checkSemicolon(NodeTraversal t, Node n) {
        StaticSourceFile staticSourceFile = n.getStaticSourceFile();
        if (staticSourceFile instanceof SourceFile) {
            boolean endsWithSemicolon;
            String code;
            SourceFile sourceFile = (SourceFile)staticSourceFile;
            try {
                code = sourceFile.getCode();
            }
            catch (IOException e) {
                return;
            }
            int length = n.getLength();
            if (length == 0) {
                return;
            }
            int position = n.getSourceOffset() + length - 1;
            boolean bl = endsWithSemicolon = code.charAt(position) == ';';
            if (!endsWithSemicolon) {
                t.report(n, MISSING_SEMICOLON, new String[0]);
            }
        }
    }
}

