
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.rya.periodic.notification.api;

import org.apache.rya.periodic.notification.notification.TimestampedNotification;

/**
 * Object that processes new {@link TimestampedNotification}s generated by {@link NotificationCoordinatorExecutor}.
 * It is expected that the NotificationCoordinatorExecutor will this Object with notifications to perform work via some sort 
 * sort of queuing service such as a BlockingQueue or Kafka.  This Object processes the notifications by retrieving
 * query results associated with the Periodic Query id given by {@link TimestampedNotification#getId()}, parsing them
 * and then providing them to another service to be exported.
 *
 */
public interface NotificationProcessor {

    /**
     * Processes {@link TimestampedNotification}s by retrieving the Periodic Query results
     * associated the query id given by {@link TimestampedNotification#getId()}.
     * @param notification - contains information about which query results to retrieve
     */
    public void processNotification(TimestampedNotification notification);
    
}
