/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletEventDispatcher
implements ServletListener {
    private static final int THREAD_POOL_SIZE = 3;
    private static final Logger LOG = LoggerFactory.getLogger(ServletEventDispatcher.class);
    private final ScheduledExecutorService executors;
    private final ServiceTracker<ServletListener, ServletListener> servletListenerTracker;
    private final Set<ServletListener> listeners = new CopyOnWriteArraySet<ServletListener>();
    private final Map<Bundle, Map<String, ServletEvent>> states = new ConcurrentHashMap<Bundle, Map<String, ServletEvent>>();

    public ServletEventDispatcher(final BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle Context");
        this.executors = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("ServletEventDispatcher: " + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.servletListenerTracker = new ServiceTracker(bundleContext, ServletListener.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletListener, ServletListener>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServletListener addingService(ServiceReference<ServletListener> reference) {
                ServletListener listener = (ServletListener)bundleContext.getService(reference);
                if (listener != null) {
                    LOG.debug("New ServletListener added: {}", (Object)listener.getClass().getName());
                    Set set = ServletEventDispatcher.this.listeners;
                    synchronized (set) {
                        ServletEventDispatcher.this.sendInitialEvents(listener);
                        ServletEventDispatcher.this.listeners.add(listener);
                    }
                }
                return listener;
            }

            public void modifiedService(ServiceReference<ServletListener> reference, ServletListener service) {
            }

            public void removedService(ServiceReference<ServletListener> reference, ServletListener service) {
                ServletEventDispatcher.this.listeners.remove(service);
                bundleContext.ungetService(reference);
                LOG.debug("ServletListener is removed: {}", (Object)service.getClass().getName());
            }
        });
        this.servletListenerTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servletEvent(ServletEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending web event " + event + " for bundle " + event.getBundle().getSymbolicName());
        }
        Set<ServletListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(event);
            Map<String, ServletEvent> events = this.states.get(event.getBundle());
            if (events == null) {
                events = new LinkedHashMap<String, ServletEvent>();
                this.states.put(event.getBundle(), events);
            }
            events.put(event.getAlias(), event);
        }
    }

    void destroy() {
        this.servletListenerTracker.close();
        this.executors.shutdown();
        try {
            this.executors.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendInitialEvents(ServletListener listener) {
        for (Map.Entry<Bundle, Map<String, ServletEvent>> entry : this.states.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                for (ServletEvent event : entry.getValue().values()) {
                    this.callListener(listener, new ServletEvent(event, true));
                }
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListeners(ServletEvent servletEvent) {
        for (ServletListener listener : this.listeners) {
            try {
                this.callListener(listener, servletEvent);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(final ServletListener listener, final ServletEvent event) {
        try {
            this.executors.invokeAny(Collections.singleton(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    listener.servletEvent(event);
                    return null;
                }
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOG.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOG.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }
}

