/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.Packet;

public final class ByteArrayPacket
implements Packet {
    private final byte[] buffer;
    private final int offset;
    private final int capacity;
    private int position;
    private int limit;
    private int remaining;

    public ByteArrayPacket(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayPacket(ByteSequence sequence) {
        this(sequence.getData(), sequence.getOffset(), sequence.getLength());
    }

    public ByteArrayPacket(byte[] buffer, int offset, int capacity) {
        this.buffer = buffer;
        this.offset = offset;
        this.capacity = capacity;
        this.position = 0;
        this.limit = capacity;
        this.remaining = this.limit - this.position;
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.position = position;
        this.remaining = this.limit - position;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
        this.remaining = limit - this.position;
    }

    public void flip() {
        this.limit = this.position;
        this.position = 0;
        this.remaining = this.limit - this.position;
    }

    public int remaining() {
        return this.remaining;
    }

    public void rewind() {
        this.position = 0;
        this.remaining = this.limit - this.position;
    }

    public boolean hasRemaining() {
        return this.remaining > 0;
    }

    public void clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.remaining = this.limit - this.position;
    }

    public int capacity() {
        return this.capacity;
    }

    public Packet slice() {
        return new ByteArrayPacket(this.buffer, this.offset + this.position, this.remaining);
    }

    public Packet duplicate() {
        return new ByteArrayPacket(this.buffer, this.offset, this.capacity);
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> clazz = cl.loadClass(ByteArrayPacket.class.getName());
            Constructor<?> constructor = clazz.getConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            return constructor.newInstance(this.buffer, new Integer(this.offset), new Integer(this.capacity()));
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, this.offset + this.position, this.remaining);
        this.position = this.limit;
        this.remaining = this.limit - this.position;
    }

    public void writeTo(DataOutput out) throws IOException {
        out.write(this.buffer, this.offset + this.position, this.remaining);
        this.position = this.limit;
        this.remaining = this.limit - this.position;
    }

    public int read() {
        if (this.remaining <= 0) {
            return -1;
        }
        byte rc = this.buffer[this.offset + this.position];
        ++this.position;
        this.remaining = this.limit - this.position;
        return rc & 0xFF;
    }

    public int read(byte[] data, int offset, int length) {
        if (this.remaining <= 0) {
            return -1;
        }
        int copyLength = length <= this.remaining ? length : this.remaining;
        System.arraycopy(this.buffer, this.offset + this.position, data, offset, copyLength);
        this.position += copyLength;
        this.remaining = this.limit - this.position;
        return copyLength;
    }

    public boolean write(int data) {
        if (this.remaining <= 0) {
            return false;
        }
        this.buffer[this.offset + this.position] = (byte)data;
        ++this.position;
        this.remaining = this.limit - this.position;
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        if (this.remaining <= 0) {
            return -1;
        }
        int copyLength = length <= this.remaining ? length : this.remaining;
        System.arraycopy(data, offset, this.buffer, this.offset + this.position, copyLength);
        this.position += copyLength;
        this.remaining = this.limit - this.position;
        return copyLength;
    }

    public ByteSequence asByteSequence() {
        return new ByteSequence(this.buffer, this.offset + this.position, this.remaining);
    }

    public byte[] sliceAsBytes() {
        if (this.buffer.length == this.remaining) {
            return this.buffer;
        }
        byte[] rc = new byte[this.remaining];
        int op = this.position;
        this.read(rc, 0, this.remaining);
        this.position = op;
        this.remaining = this.limit - this.position;
        return rc;
    }

    public int read(Packet dest) {
        int rc;
        int a = dest.remaining();
        int n = rc = a <= this.remaining ? a : this.remaining;
        if (rc > 0) {
            dest.write(this.buffer, this.offset + this.position, rc);
            this.position += rc;
            this.remaining = this.limit - this.position;
        }
        return rc;
    }

    public String toString() {
        return "{position=" + this.position + ",limit=" + this.limit + ",capacity=" + this.capacity + "}";
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void dispose() {
    }
}

