/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletAnnotationScanner {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public Boolean scanned = false;
    public String[] urlPatterns;
    public String servletName;
    public Integer loadOnStartup;
    public Boolean asyncSupported;
    public WebInitParam[] webInitParams;
    public MultipartConfig multiPartConfigAnnotation;
    public WebServlet annotation;

    public ServletAnnotationScanner(Class<?> clazz) {
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation == null) {
            return;
        }
        this.scanned = true;
        this.multiPartConfigAnnotation = clazz.getAnnotation(MultipartConfig.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            this.log.warn(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns");
            return;
        }
        this.urlPatterns = annotation.value();
        if (this.urlPatterns.length == 0) {
            this.urlPatterns = annotation.urlPatterns();
        }
        if (this.urlPatterns.length == 0) {
            this.log.warn(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns");
            return;
        }
        this.servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        this.webInitParams = annotation.initParams();
        this.asyncSupported = annotation.asyncSupported();
        this.loadOnStartup = annotation.loadOnStartup();
    }
}

