/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.DoubleToIntFunction;
import javax.measure.Unit;
import org.apache.sis.coverage.ConvertedCategory;
import org.apache.sis.coverage.ConvertedRange;
import org.apache.sis.coverage.IllegalSampleDimensionException;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Types;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class Category
implements Serializable {
    private static final long serialVersionUID = 2630516005075467646L;
    static final Comparator<Category> COMPARATOR = (c1, c2) -> Category.compare(c1.range.getMinDouble(true), c2.range.getMinDouble(true));
    final InternationalString name;
    final NumberRange<?> range;
    final MathTransform1D toConverse;
    final Category converse;

    static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    protected Category(Category copy) {
        this.name = copy.name;
        this.range = copy.range;
        this.toConverse = copy.toConverse;
        this.converse = copy.converse == copy ? this : new Category(copy.converse, this);
    }

    Category(Category copy, Category caller) {
        this.name = copy.name;
        this.range = copy.range;
        if (caller != null) {
            this.toConverse = copy.toConverse;
            this.converse = caller;
        } else {
            this.toConverse = Category.identity();
            this.converse = this;
        }
    }

    protected Category(CharSequence name, NumberRange<?> samples, MathTransform1D toUnits, Unit<?> units, DoubleToIntFunction toNaN) {
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        ArgumentChecks.ensureNonNull((String)"samples", samples);
        if (units != null) {
            ArgumentChecks.ensureNonNull((String)"toUnits", (Object)toUnits);
        }
        this.name = Types.toInternationalString((CharSequence)name);
        double minimum = samples.getMinDouble(true);
        double maximum = samples.getMaxDouble(true);
        boolean isNaN = Double.isNaN(minimum);
        if (!(minimum <= maximum || toUnits == null && isNaN && Double.doubleToRawLongBits(minimum) == Double.doubleToRawLongBits(maximum))) {
            throw new IllegalSampleDimensionException(Resources.format((short)24, name, samples));
        }
        if (isNaN) {
            this.range = samples;
            this.converse = this;
            this.toConverse = Category.identity();
        } else {
            try {
                MathTransform1D toSamples;
                if (toUnits != null) {
                    this.toConverse = toUnits;
                    if (toUnits.isIdentity()) {
                        this.converse = this;
                        if (!(samples instanceof MeasurementRange)) {
                            samples = new MeasurementRange(samples, units);
                        }
                        this.range = samples;
                        return;
                    }
                    toSamples = toUnits.inverse();
                } else {
                    ArgumentChecks.ensureNonNull((String)"toNaN", (Object)toNaN);
                    double value = minimum > 0.0 ? minimum : (maximum <= 0.0 ? maximum : 0.0);
                    float nan = MathFunctions.toNanFloat((int)toNaN.applyAsInt(value));
                    this.toConverse = (MathTransform1D)MathTransforms.linear((double)0.0, (double)nan);
                    toSamples = (MathTransform1D)MathTransforms.linear((double)0.0, (double)value);
                }
                this.range = samples;
                this.converse = new ConvertedCategory(this, toSamples, toUnits != null, units);
            }
            catch (TransformException e) {
                throw new IllegalSampleDimensionException(Resources.format((short)31, name), e);
            }
        }
    }

    Category(Category original, MathTransform1D toSamples, boolean isQuantitative, Unit<?> units) throws TransformException {
        this.converse = original;
        this.name = original.name;
        this.toConverse = Objects.requireNonNull(toSamples);
        NumberRange<?> r = original.range;
        boolean minIncluded = r.isMinIncluded();
        boolean maxIncluded = r.isMaxIncluded();
        double[] extremums = new double[]{r.getMinDouble(), r.getMaxDouble(), r.getMinDouble(!minIncluded), r.getMaxDouble(!maxIncluded)};
        original.toConverse.transform(extremums, 0, extremums, 0, extremums.length);
        double d = extremums[minIncluded ? 2 : 0];
        int n = maxIncluded ? 3 : 1;
        if (d > extremums[n]) {
            ArraysExt.swap((double[])extremums, (int)0, (int)1);
            ArraysExt.swap((double[])extremums, (int)2, (int)3);
            boolean tmp = minIncluded;
            minIncluded = maxIncluded;
            maxIncluded = tmp;
        }
        if (isQuantitative) {
            this.range = new ConvertedRange(extremums, minIncluded, maxIncluded, units);
        } else {
            double minimum = extremums[minIncluded ? 0 : 2];
            float min = (float)minimum;
            this.range = Double.doubleToRawLongBits(minimum) == Double.doubleToRawLongBits(min) ? NumberRange.create(Float.class, (Number)Float.valueOf(min)) : NumberRange.create(Double.class, (Number)minimum);
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    Category converted() {
        return this.converse;
    }

    final boolean isConvertedQualitative() {
        return Double.isNaN(this.range.getMinDouble());
    }

    public boolean isQuantitative() {
        return !this.converted().isConvertedQualitative();
    }

    public NumberRange<?> getSampleRange() {
        return this.range;
    }

    public Optional<MeasurementRange<?>> getMeasurementRange() {
        NumberRange<?> mr = this.converted().range;
        if (Double.isNaN(mr.getMinDouble())) {
            return Optional.empty();
        }
        return Optional.of((MeasurementRange)mr);
    }

    final Object getRangeLabel() {
        Number minimum;
        if (this.range != null && (minimum = (Number)((Object)this.range.getMinValue())) != null && minimum.equals(this.range.getMaxValue())) {
            float f = minimum.floatValue();
            if (Float.isNaN(f)) {
                return "NaN #" + MathFunctions.toNanOrdinal((float)f);
            }
            return minimum;
        }
        return this.range;
    }

    public Optional<MathTransform1D> getTransferFunction() {
        if (this.converse.isConvertedQualitative()) {
            return Optional.empty();
        }
        return Optional.of(this.toConverse);
    }

    public Category forConvertedValues(boolean converted) {
        return converted ? this.converse : this;
    }

    static MathTransform1D identity() {
        return (MathTransform1D)MathTransforms.identity((int)1);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            NumberRange<?> other;
            Category that = (Category)object;
            if (this.name.equals((Object)that.name) && (this.range == (other = that.range) || this.range.equals(other) && Double.doubleToRawLongBits(this.range.getMinDouble()) == Double.doubleToRawLongBits(other.getMinDouble()) && Double.doubleToRawLongBits(this.range.getMaxDouble()) == Double.doubleToRawLongBits(other.getMaxDouble()))) {
                return this.toConverse.equals((Object)that.toConverse);
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\u201c" + (CharSequence)this.name + "\u201d:\u00a0" + this.getRangeLabel() + ']';
    }
}

