/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.projectsupport.PreparePackageMojo;

@Mojo(name="prepare-test-webapp", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public class PrepareTestWebAppMojo
extends PreparePackageMojo {
    @Parameter(property="project.build.directory", readonly=true)
    private File buildDirectory;
    @Parameter(defaultValue="16")
    private int startLevel;
    @Parameter(defaultValue="${project.build.directory}/launchpad-bundles")
    private File outputDirectory;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        super.executeWithArtifacts();
        this.copy(this.getPrimaryArtifact(), this.startLevel, null, this.getOutputDirectory());
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void unpackBaseArtifact() throws MojoExecutionException {
    }

    private File getPrimaryArtifact() throws MojoExecutionException {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(this.project.getPackaging());
        String artifactName = this.project.getBuild().getFinalName() + "." + handler.getExtension();
        File file = new File(this.buildDirectory, artifactName);
        if (!file.exists()) {
            throw new MojoExecutionException("Project's primary artifact (" + file.getPath() + ") doesn't exist.");
        }
        return file;
    }
}

