/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.PageManager;

public class Reference {
    private final String property;
    private final Resource resource;

    public Reference(Resource resource, String property) {
        this.resource = resource;
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public String getSubPath() {
        return StringUtils.replaceOnce((String)this.resource.getPath(), (String)this.getContainingPage().getPath(), (String)"");
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isPage() {
        PageManager pageMgr = (PageManager)this.resource.adaptTo(PageManager.class);
        if (pageMgr != null) {
            return pageMgr.getPage() != null;
        }
        return false;
    }

    public Page getContainingPage() {
        PageManager pageMgr = (PageManager)this.resource.adaptTo(PageManager.class);
        if (pageMgr != null) {
            return pageMgr.getPage();
        }
        return null;
    }

    public String toString() {
        return this.resource.getPath() + "@" + this.property;
    }
}

