/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.rrd4j.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.inventory.ZipAttachmentProvider;
import org.apache.sling.commons.metrics.rrd4j.impl.CopyMetricRegistryListener;
import org.apache.sling.commons.metrics.rrd4j.impl.RRD4JReporter;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, service={InventoryPrinter.class, ZipAttachmentProvider.class}, property={"felix.inventory.printer.name=rrd4j-reporter", "felix.inventory.printer.title=Sling Metrics RRD4J reporter", "felix.inventory.printer.format=TEXT"})
@Designate(ocd=Configuration.class)
public class CodahaleMetricsReporter
implements InventoryPrinter,
ZipAttachmentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CodahaleMetricsReporter.class);
    private Configuration configuration;
    private File rrd;
    private ScheduledReporter reporter;
    private Map<String, CopyMetricRegistryListener> listeners = new ConcurrentHashMap<String, CopyMetricRegistryListener>();
    private MetricRegistry metricRegistry = new MetricRegistry();

    @Activate
    void activate(BundleContext context, Configuration config) throws Exception {
        LOG.info("Starting RRD4J Metrics reporter");
        this.configuration = config;
        this.rrd = CodahaleMetricsReporter.getSafePath(context, config);
        this.reporter = RRD4JReporter.forRegistry(this.metricRegistry).withPath(this.rrd).withDatasources(config.datasources()).withArchives(config.archives()).withStep(config.step()).build();
        if (this.reporter != null) {
            this.reporter.start((long)config.step(), TimeUnit.SECONDS);
            LOG.info("Started RRD4J Metrics reporter: {}.", (Object)this.reporter);
        } else {
            LOG.warn("Illegal config will not start the RRD reporter. [path={}, datasources={}, archives={}, step={}].", new Object[]{this.rrd.getPath(), config.datasources(), config.archives(), config.step()});
        }
    }

    private static File getSafePath(BundleContext context, Configuration config) {
        String home;
        File rrd;
        String path = config.path();
        if (path == null || path.isEmpty()) {
            path = "metrics/metrics.rrd";
        }
        if (!(rrd = new File(path)).isAbsolute() && (home = context.getProperty("sling.home")) != null) {
            rrd = new File(home, rrd.getPath());
        }
        return rrd;
    }

    @Deactivate
    void deactivate() {
        LOG.info("Stopping RRD4J Metrics reporter");
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
        this.configuration = null;
        this.rrd = null;
        LOG.info("Stopped RRD4J Metrics reporter");
    }

    @Reference(service=MetricRegistry.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    synchronized void addMetricRegistry(MetricRegistry metricRegistry, Map<String, Object> properties) {
        String name = (String)properties.get("name");
        if (name == null) {
            name = metricRegistry.toString();
        }
        CopyMetricRegistryListener listener = new CopyMetricRegistryListener(this.metricRegistry, name);
        listener.start(metricRegistry);
        this.listeners.put(name, listener);
        LOG.info("Bound Metrics Registry {} ", (Object)name);
    }

    synchronized void removeMetricRegistry(MetricRegistry metricRegistry, Map<String, Object> properties) {
        CopyMetricRegistryListener metricRegistryListener;
        String name = (String)properties.get("name");
        if (name == null) {
            name = metricRegistry.toString();
        }
        if ((metricRegistryListener = this.listeners.get(name)) != null) {
            metricRegistryListener.stop(metricRegistry);
            this.listeners.remove(name);
        }
        LOG.info("Unbound Metrics Registry {} ", (Object)name);
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        if (format == Format.TEXT) {
            pw.println("Sling Metrics RRD4J reporter");
            pw.println("Path: " + this.rrd.getAbsolutePath());
            pw.println("Step: " + this.configuration.step());
            pw.println("Datasources: " + Arrays.asList(this.configuration.datasources()));
            pw.println("Archives: " + Arrays.asList(this.configuration.archives()));
        }
    }

    public void addAttachments(ZipOutputStream zos, String namePrefix) throws IOException {
        File props;
        if (this.rrd.exists()) {
            this.appendFile(zos, this.rrd, namePrefix + this.configuration.path());
        }
        if ((props = new File(this.rrd.getParentFile(), this.rrd.getName() + ".properties")).exists()) {
            this.appendFile(zos, props, namePrefix + this.configuration.path() + ".properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(ZipOutputStream zos, File file, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setSize(file.length());
        zos.putNextEntry(entry);
        try {
            Files.copy(file.toPath(), zos);
            zos.flush();
        }
        finally {
            zos.closeEntry();
        }
    }

    @ObjectClassDefinition(name="Apache Sling Metrics reporter writing to RRD4J", description="For syntax details on RRD data-source and round robin archive definitions see https://oss.oetiker.ch/rrdtool/doc/rrdcreate.en.html and https://github.com/rrd4j/rrd4j/wiki/Tutorial. Changing any attribute in this configuration will replace an existing RRD file with a empty one!")
    public static @interface Configuration {
        @AttributeDefinition(name="Data sources", description="RRDTool data source definitions (e.g. 'DS:oak_SESSION_LOGIN_COUNTER:COUNTER:300:0:U'). Replace colon characters in the metric name with an underscore!")
        public String[] datasources() default {};

        @AttributeDefinition(name="Step", description="The base interval in seconds with which data will be fed into the RRD")
        public int step() default 5;

        @AttributeDefinition(name="Archives", description="RRDTool round robin archive definitions. The default configuration defines four archives based on a default step of five seconds: 1) per minute averages for six hours, 2) per five minute averages 48 hours, 3) per hour averages for four weeks, 4) per day averages for one year.")
        public String[] archives() default {"RRA:AVERAGE:0.5:12:360", "RRA:AVERAGE:0.5:60:576", "RRA:AVERAGE:0.5:720:336", "RRA:AVERAGE:0.5:17280:365"};

        @AttributeDefinition(name="Path", description="Path of the RRD file where metrics are stored. If the path is relative, it is resolved relative to the value of the framework property 'sling.home' when available, otherwise relative to the current working directory.")
        public String path() default "metrics/metrics.rrd";
    }
}

