/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.EventHelper;
import org.apache.sling.discovery.commons.providers.base.DummyDiscoveryService;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger logger = LoggerFactory.getLogger(TestHelper.class);

    public static void assertEvents(ViewStateManagerImpl mgr, DummyListener listener, TopologyEvent ... events) {
        TestHelper.waitForAsyncEvents(mgr);
        Assert.assertEquals((long)events.length, (long)listener.countEvents());
        block5: for (int i = 0; i < events.length; ++i) {
            TopologyEvent e = events[i];
            Assert.assertEquals((Object)e.getType(), (Object)listener.getEvents().get(i).getType());
            switch (e.getType()) {
                case TOPOLOGY_INIT: {
                    Assert.assertNull((Object)listener.getEvents().get(i).getOldView());
                    Assert.assertEquals((Object)e.getNewView(), (Object)listener.getEvents().get(i).getNewView());
                    continue block5;
                }
                case TOPOLOGY_CHANGING: {
                    Assert.assertEquals((Object)e.getOldView(), (Object)listener.getEvents().get(i).getOldView());
                    Assert.assertNull((Object)listener.getEvents().get(i).getNewView());
                    continue block5;
                }
                case PROPERTIES_CHANGED: 
                case TOPOLOGY_CHANGED: {
                    Assert.assertEquals((Object)e.getOldView(), (Object)listener.getEvents().get(i).getOldView());
                    Assert.assertEquals((Object)e.getNewView(), (Object)listener.getEvents().get(i).getNewView());
                    continue block5;
                }
                default: {
                    Assert.fail((String)"no other type supported yet");
                }
            }
        }
        listener.clearEvents();
    }

    public static void waitForAsyncEvents(ViewStateManagerImpl mgr) {
        int sleep = 1;
        while (mgr.getAsyncEventSender().hasInFlightEvent()) {
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                logger.error("waitForFlush: got interrupted: " + String.valueOf(e), (Throwable)e);
            }
            sleep = Math.min(20, sleep + 1);
        }
        return;
    }

    public static void assertNoEvents(DummyListener listener) {
        Assert.assertEquals((long)0L, (long)listener.countEvents());
    }

    public static void randomEventLoop(ViewStateManagerImpl mgr, DummyDiscoveryService sds, int loopSize, int delayInMillis, Random random, DummyListener ... listeners) throws InterruptedException {
        for (int i = 0; i < loopSize; ++i) {
            int j;
            int j2;
            boolean shouldCallChanging = random.nextBoolean();
            if (shouldCallChanging) {
                logger.debug("randomEventLoop: calling handleChanging...");
                mgr.handleChanging();
                logger.debug("randomEventLoop: waiting for async events....");
                TestHelper.waitForAsyncEvents(mgr);
                logger.debug("randomEventLoop: asserting CHANGING event was sent...");
                for (j2 = 0; j2 < listeners.length; ++j2) {
                    TestHelper.assertEvents(mgr, listeners[j2], EventHelper.newChangingEvent((BaseTopologyView)listeners[j2].getLastView()));
                }
            } else {
                logger.debug("randomEventLoop: asserting no events...");
                for (j2 = 0; j2 < listeners.length; ++j2) {
                    TestHelper.assertNoEvents(listeners[j2]);
                }
            }
            DummyTopologyView view = new DummyTopologyView().addInstance();
            BaseTopologyView[] lastViews = new BaseTopologyView[listeners.length];
            for (int j3 = 0; j3 < listeners.length; ++j3) {
                lastViews[j3] = listeners[j3].getLastView();
            }
            logger.debug("randomEventLoop: calling handleNewView");
            if (sds != null) {
                sds.setTopoology(view);
            }
            DummyTopologyView clonedView = view.clone();
            mgr.handleNewView((BaseTopologyView)view);
            if (delayInMillis > 0) {
                logger.debug("randomEventLoop: waiting " + delayInMillis + "ms ...");
                Thread.sleep(delayInMillis);
                logger.debug("randomEventLoop: waiting " + delayInMillis + "ms done.");
            }
            Assert.assertEquals((long)0L, (long)mgr.waitForAsyncEvents(500L));
            if (!shouldCallChanging) {
                logger.debug("randomEventLoop: asserting CHANGING, CHANGED events were sent");
                for (j = 0; j < listeners.length; ++j) {
                    TestHelper.assertEvents(mgr, listeners[j], EventHelper.newChangingEvent((BaseTopologyView)lastViews[j]), EventHelper.newChangedEvent((BaseTopologyView)lastViews[j], (BaseTopologyView)view));
                }
                continue;
            }
            logger.debug("randomEventLoop: asserting CHANGED event was sent");
            for (j = 0; j < listeners.length; ++j) {
                TestHelper.assertEvents(mgr, listeners[j], EventHelper.newChangedEvent((BaseTopologyView)lastViews[j], (BaseTopologyView)clonedView));
            }
        }
    }

    public static DummyTopologyView newView(boolean isCurrent, String leaderId, String localId, String ... slingIds) {
        return TestHelper.newView(UUID.randomUUID().toString(), UUID.randomUUID().toString(), isCurrent, leaderId, localId, slingIds);
    }

    public static DummyTopologyView newView(String syncId, String clusterId, boolean isCurrent, String leaderId, String localId, String ... slingIds) {
        DummyTopologyView topology = new DummyTopologyView(syncId);
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        for (String slingId : slingIds) {
            DefaultInstanceDescription id = new DefaultInstanceDescription(cluster, slingId.equals(leaderId), slingId.equals(localId), slingId, new HashMap());
            topology.addInstanceDescription((InstanceDescription)id);
        }
        if (!isCurrent) {
            topology.setNotCurrent();
        }
        return topology;
    }
}

