/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.exporter;

import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.packaging.impl.exporter.LocalDistributionPackageExporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={DistributionPackageExporter.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=Exporter name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class LocalDistributionPackageExporterFactory
implements DistributionPackageExporter {
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    private DistributionPackageExporter exporter;

    @Activate
    public void activate(Map<String, Object> config) {
        this.exporter = new LocalDistributionPackageExporter(this.packageBuilder);
    }

    @Override
    public void exportPackages(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionPackageProcessor packageProcessor) throws DistributionException {
        this.exporter.exportPackages(resourceResolver, distributionRequest, packageProcessor);
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String distributionPackageId) throws DistributionException {
        return this.exporter.getPackage(resourceResolver, distributionPackageId);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Exporter - Local Package Exporter Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the exporter.")
        public String name();

        @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
        public String packageBuilder_target();
    }
}

