/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.ItemNotFoundException;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.api.JackrabbitSession;
import relocated_for_contentpackage.org.apache.jackrabbit.api.security.user.Authorizable;
import relocated_for_contentpackage.org.apache.jackrabbit.api.security.user.Group;
import relocated_for_contentpackage.org.apache.jackrabbit.api.security.user.UserManager;
import relocated_for_contentpackage.org.apache.jackrabbit.util.Text;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.UserManagement;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.DocViewNode;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.DocViewProperty;

public class JackrabbitUserManagement
implements UserManagement {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitUserManagement.class);

    @Override
    public boolean isAuthorizableNodeType(String ntName) {
        return ntName.equals("rep:Group") || ntName.equals("rep:User");
    }

    @Override
    public String getAuthorizablePath(Session session, String name) {
        try {
            UUID uuid = UUID.nameUUIDFromBytes(name.toLowerCase().getBytes("UTF-8"));
            return session.getNodeByIdentifier(uuid.toString()).getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getAuthorizableId(DocViewNode node) {
        DocViewProperty idProp = node.props.get("rep:authorizableId");
        if (idProp == null || idProp.isMulti) {
            return Text.unescapeIllegalJcrChars(node.name);
        }
        return idProp.values[0];
    }

    @Override
    public void addMembers(Session session, String id, String[] membersUUID) {
        Authorizable auth;
        UserManager uMgr;
        if (!(session instanceof JackrabbitSession)) {
            log.warn("Unable to update membership. no jackrabbit session.");
            return;
        }
        try {
            uMgr = ((JackrabbitSession)session).getUserManager();
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving user manager.", (Object)id, (Object)e);
            return;
        }
        try {
            auth = uMgr.getAuthorizable(id);
        }
        catch (RepositoryException e) {
            log.warn("Unable to update membership of {}. Error while retrieving authorizable.", (Object)id, (Object)e);
            return;
        }
        if (auth == null) {
            log.warn("Unable to update membership of {}. No such authorizable.", (Object)id);
            return;
        }
        if (!(auth instanceof Group)) {
            log.warn("Unable to update membership of {}. No a group.", (Object)id);
            return;
        }
        Group grp = (Group)auth;
        for (String uuid : membersUUID) {
            try {
                Node authNode = session.getNodeByIdentifier(uuid);
                String authPath = authNode.getPath();
                Authorizable member = uMgr.getAuthorizableByPath(authPath);
                if (member == null) {
                    log.warn("unable to add authorizable '{}' to group '{}'. Node at {} is not an authorizable.", (Object)uuid, (Object)authPath);
                    continue;
                }
                String memberId = member.getID();
                try {
                    if (grp.isDeclaredMember(member)) {
                        log.debug("ignoring to add authorizable '{}' to group '{}'. Already member.", (Object)memberId, (Object)id);
                        continue;
                    }
                    grp.addMember(member);
                    log.debug("added authorizable '{}' to group '{}'.", (Object)memberId, (Object)id);
                }
                catch (RepositoryException e) {
                    log.error("Error while adding authorizable '{}' to group '{}': {}", new Object[]{memberId, id, e});
                }
            }
            catch (ItemNotFoundException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. No such node.", (Object)uuid, (Object)id);
            }
            catch (RepositoryException e) {
                log.warn("unable to add authorizable '{}' to group '{}'. Internal Error: {}", new Object[]{uuid, id, e});
            }
        }
    }
}

