/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStatCache {
    private static final Logger LOG = LoggerFactory.getLogger(FileStatCache.class);
    private final Map<String, FileStat> fileStates = new ConcurrentHashMap<String, FileStat>();
    private final String providerFilePath;

    FileStatCache(File providerFile) {
        this.providerFilePath = providerFile.getPath();
    }

    void clear() {
        this.fileStates.clear();
    }

    public boolean isDirectory(File file) {
        return this.getFileState(file).isDirectory();
    }

    public boolean isFile(File file) {
        return this.getFileState(file).isFile();
    }

    public boolean exists(File file) {
        return this.getFileState(file).exists();
    }

    private FileStat getFileState(File file) {
        String path = this.relativePath(this.providerFilePath, file.getPath());
        if (StringUtils.isBlank((CharSequence)path)) {
            return FileStat.EXISTING_DIRECTORY;
        }
        FileStat fileStat = this.fileStates.get(path);
        if (fileStat == null) {
            if (!this.parentExists(path, file)) {
                LOG.trace("Does not exist (via parent): {}", (Object)path);
                return FileStat.NON_EXISTING;
            }
            fileStat = FileStat.compute(file);
            this.fileStates.put(path, fileStat);
            if (fileStat.exists()) {
                CacheStatistics.EXISTS_ACCESS.uncachedAccess(path);
            } else {
                CacheStatistics.NOT_EXISTS_ACCESS.uncachedAccess(path);
            }
        } else if (fileStat.exists()) {
            CacheStatistics.EXISTS_ACCESS.cachedAccess(path);
        } else {
            CacheStatistics.NOT_EXISTS_ACCESS.cachedAccess(path);
        }
        return fileStat;
    }

    private String relativePath(String basePath, String path) {
        String suffix = StringUtils.removeStart((String)path, (String)basePath);
        String normalizedPath = StringUtils.replaceChars((String)suffix, (char)'\\', (char)'/');
        if (normalizedPath == null || normalizedPath.startsWith(".") && normalizedPath.length() > 2) {
            return "../" + ResourceUtil.getName((String)path);
        }
        return normalizedPath;
    }

    private FileStat getClosestCachedAncestorState(String path) {
        String nextAncestorPath;
        String ancestorPath = path;
        FileStat fileStat = null;
        while (!StringUtils.equals((CharSequence)ancestorPath, (CharSequence)(nextAncestorPath = StringUtils.substringBeforeLast((String)ancestorPath, (String)"/")))) {
            ancestorPath = nextAncestorPath;
            if (ancestorPath != null) {
                fileStat = this.fileStates.get(ancestorPath);
            }
            if (ancestorPath != null && fileStat == null) continue;
        }
        return fileStat;
    }

    private boolean parentExists(String path, File file) {
        FileStat cachedAncestorState = this.getClosestCachedAncestorState(path);
        if (cachedAncestorState != null && !cachedAncestorState.exists()) {
            return false;
        }
        File parentFile = file.getParentFile();
        return parentFile == null || this.exists(parentFile);
    }

    private static enum FileStat {
        EXISTING_DIRECTORY(true, true),
        EXISTING_FILE(true, false),
        NON_EXISTING(false, false);

        private final boolean exists;
        private final boolean isDirectory;

        public static FileStat compute(File file) {
            if (file.isDirectory()) {
                return EXISTING_DIRECTORY;
            }
            if (file.exists()) {
                return EXISTING_FILE;
            }
            return NON_EXISTING;
        }

        private FileStat(boolean exists, boolean isDirectory) {
            this.exists = exists;
            this.isDirectory = isDirectory;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isFile() {
            return this.exists && !this.isDirectory;
        }

        public String toString() {
            return this.exists() ? (this.isDirectory() ? "existing directory" : "existing file") : "non existing file";
        }
    }

    private static enum CacheStatistics {
        EXISTS_ACCESS("Does exist (cached: {}/{}): {}", "Does exist (added to cache: {}/{}): {}"),
        NOT_EXISTS_ACCESS("Does not exist (cached: {}/{}): {}", "Does not exist (added to cache: {}/{}): {}");

        private final String cachedAccessLogStatement;
        private final String uncachedAccessLogStatement;
        private final AtomicLong cachedAccess;
        private final AtomicLong uncachedAccess;

        private CacheStatistics(String cachedAccessLogStatement, String uncachedAccessLogStatement) {
            this.cachedAccessLogStatement = cachedAccessLogStatement;
            this.uncachedAccessLogStatement = uncachedAccessLogStatement;
            this.cachedAccess = new AtomicLong(0L);
            this.uncachedAccess = new AtomicLong(0L);
        }

        public void cachedAccess(String path) {
            long cached = this.cachedAccess.incrementAndGet();
            long uncached = this.uncachedAccess.get();
            this.log(cached, uncached, true, path);
        }

        public void uncachedAccess(String path) {
            long cached = this.cachedAccess.get();
            long uncached = this.uncachedAccess.incrementAndGet();
            this.log(cached, uncached, false, path);
        }

        private void log(long cached, long uncached, boolean logCached, String path) {
            if (LOG.isDebugEnabled()) {
                String statement = logCached ? this.cachedAccessLogStatement : this.uncachedAccessLogStatement;
                long all = uncached + uncached;
                long count = logCached ? cached : uncached;
                LOG.trace(statement, new Object[]{count, all, path});
                if (!LOG.isTraceEnabled() && all % 100000L == 0L) {
                    LOG.debug(statement, new Object[]{count, all, path});
                }
            }
        }
    }
}

